/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.EmployeeHearing;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.Pwr;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_HEARINGS")
@SequenceGenerator(name="SEQ_EGLC_HEARINGS", sequenceName="SEQ_EGLC_HEARINGS", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class Hearings
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_HEARINGS = "SEQ_EGLC_HEARINGS";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_HEARINGS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Temporal(value=TemporalType.DATE)
    @Audited
    private Date hearingDate;
    @ManyToOne
    @Valid
    @JoinColumn(name="legalcase", nullable=false)
    @Audited
    private LegalCase legalCase;
    @Column(name="isstandingcounselpresent")
    @Audited
    private boolean isStandingCounselPresent;
    @Length(max=128)
    @Audited
    private String additionalLawyers;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="hearing", orphanRemoval=true)
    @Audited
    private Set<EmployeeHearing> employeeHearingList = new HashSet<EmployeeHearing>(0);
    @Transient
    @Audited
    private List<EmployeeHearing> positionTemplList = new ArrayList<EmployeeHearing>();
    @Length(max=1024)
    @Audited
    private String hearingOutcome;
    @Audited
    private boolean isSeniorStandingCounselPresent;
    @Length(max=1024)
    @Column(name="purposeofhearing")
    @Audited
    private String purposeofHearings;
    @Length(max=50)
    @Audited
    private String referenceNumber;

    public Date getHearingDate() {
        return this.hearingDate;
    }

    public void setHearingDate(Date hearingDate) {
        this.hearingDate = hearingDate;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public String getAdditionalLawyers() {
        return this.additionalLawyers;
    }

    public void setAdditionalLawyers(String additionalLawyers) {
        this.additionalLawyers = additionalLawyers;
    }

    public String getHearingOutcome() {
        return this.hearingOutcome;
    }

    public void setHearingOutcome(String hearingOutcome) {
        this.hearingOutcome = hearingOutcome;
    }

    public boolean getIsSeniorStandingcounselpresent() {
        return this.isSeniorStandingCounselPresent;
    }

    public void setIsSeniorStandingcounselpresent(boolean isSeniorStandingcounselpresent) {
        this.isSeniorStandingCounselPresent = isSeniorStandingcounselpresent;
    }

    public String getPurposeofHearings() {
        return this.purposeofHearings;
    }

    public void setPurposeofHearings(String purposeofHearings) {
        this.purposeofHearings = purposeofHearings;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean getIsStandingCounselPresent() {
        return this.isStandingCounselPresent;
    }

    public void setIsStandingCounselPresent(boolean isStandingCounselPresent) {
        this.isStandingCounselPresent = isStandingCounselPresent;
    }

    public void setSeniorStandingCounselPresent(boolean isSeniorStandingCounselPresent) {
        this.isSeniorStandingCounselPresent = isSeniorStandingCounselPresent;
    }

    public void setStandingCounselPresent(boolean isStandingCounselPresent) {
        this.isStandingCounselPresent = isStandingCounselPresent;
    }

    public List<EmployeeHearing> getTempEmplyeeHearing() {
        ArrayList<EmployeeHearing> tempList = new ArrayList<EmployeeHearing>();
        for (EmployeeHearing temp : this.employeeHearingList) {
            tempList.add(temp);
        }
        return tempList;
    }

    public Set<EmployeeHearing> getEmployeeHearingList() {
        return this.employeeHearingList;
    }

    public void setEmployeeHearingList(Set<EmployeeHearing> employeeHearingList) {
        this.employeeHearingList = employeeHearingList;
    }

    public List<EmployeeHearing> getPositionTemplList() {
        return this.positionTemplList;
    }

    public void setPositionTemplList(List<EmployeeHearing> positionTemplList) {
        this.positionTemplList = positionTemplList;
    }

    public Date getCaDueDate() {
        Date caDueDate = null;
        for (Pwr pwr : this.getLegalCase().getPwrList()) {
            caDueDate = pwr.getCaDueDate();
        }
        return caDueDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getHearingDate() != null) {
            if (this.getCaDueDate() != null && !DateUtils.compareDates((Date)this.getHearingDate(), (Date)this.getCaDueDate())) {
                errors.add(new ValidationError("hearingDate", "hearingDate.greaterThan.caDueDate"));
            }
            if (this.legalCase.getCaseReceivingDate() != null && !DateUtils.compareDates((Date)this.getHearingDate(), (Date)this.legalCase.getCaseReceivingDate())) {
                errors.add(new ValidationError("hearingDate", "hearingDate.greaterThan.caseReceivingDate"));
            }
            if (!DateUtils.compareDates((Date)this.getHearingDate(), (Date)this.legalCase.getCaseDate())) {
                errors.add(new ValidationError("hearingDate", "hearingDate.greaterThan.caseDate"));
            }
        }
        return errors;
    }

    public String getEmployeeHearing() {
        StringBuilder tempStr = new StringBuilder();
        for (EmployeeHearing temp : this.employeeHearingList) {
            if (temp.getEmployee().getName() == null) continue;
            if (tempStr.length() == 0) {
                tempStr.append(temp.getEmployee().getName());
                continue;
            }
            tempStr.append(",\n").append(temp.getEmployee().getName());
        }
        return tempStr.toString();
    }
}

