/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.lcms.masters.entity.GovernmentDepartment;
import org.egov.lcms.masters.repository.GovernmentDepartmentRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GovernmentDepartmentService {
    private final GovernmentDepartmentRepository governmentDepartmentRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public GovernmentDepartmentService(GovernmentDepartmentRepository governmentDepartmentRepository) {
        this.governmentDepartmentRepository = governmentDepartmentRepository;
    }

    @Transactional
    public GovernmentDepartment persist(GovernmentDepartment governmentDepartment) {
        return (GovernmentDepartment)((Object)this.governmentDepartmentRepository.save((Object)governmentDepartment));
    }

    public List<GovernmentDepartment> findAll() {
        return this.governmentDepartmentRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public GovernmentDepartment findByName(String name) {
        return this.governmentDepartmentRepository.findByName(name);
    }

    public GovernmentDepartment findByCode(String code) {
        return this.governmentDepartmentRepository.findByCode(code);
    }

    public GovernmentDepartment findOne(Long id) {
        return (GovernmentDepartment)((Object)this.governmentDepartmentRepository.findOne(id));
    }

    public List<GovernmentDepartment> getActiveGovernmentDepartment() {
        return this.governmentDepartmentRepository.findByActiveTrueOrderByNameAsc();
    }

    public List<GovernmentDepartment> search(GovernmentDepartment governmentDepartment) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(GovernmentDepartment.class);
        Root governmentDepartmentObj = createQuery.from(GovernmentDepartment.class);
        createQuery.select((Selection)governmentDepartmentObj);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType GovernmentDepartment2 = m.entity(GovernmentDepartment.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (governmentDepartment.getName() == null && governmentDepartment.getCode() == null && governmentDepartment.getActive() == null) {
            resultList = this.findAll();
        } else {
            if (governmentDepartment.getName() != null) {
                String interimOrderType = "%" + governmentDepartment.getName().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)governmentDepartmentObj.get("name")));
                predicates.add(cb.like(cb.lower((Expression)governmentDepartmentObj.get(GovernmentDepartment2.getDeclaredSingularAttribute("name", String.class))), interimOrderType));
            }
            if (governmentDepartment.getCode() != null) {
                String code = "%" + governmentDepartment.getCode().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)governmentDepartmentObj.get("code")));
                predicates.add(cb.like(cb.lower((Expression)governmentDepartmentObj.get(GovernmentDepartment2.getDeclaredSingularAttribute("code", String.class))), code));
            }
            if (governmentDepartment.getActive() != null) {
                if (governmentDepartment.getActive().booleanValue()) {
                    predicates.add(cb.equal((Expression)governmentDepartmentObj.get(GovernmentDepartment2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)true));
                } else {
                    predicates.add(cb.equal((Expression)governmentDepartmentObj.get(GovernmentDepartment2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)false));
                }
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }
}

