/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.utils;

import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseDocuments;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LegalCaseUtil {
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private LegalCaseRepository legalCaseRepository;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private DepartmentService departmentService;

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusForModuleAndCode(String moduleName, String statusCode) {
        EgwStatus status = this.egwStatusDAO.getStatusByModuleAndCode(moduleName, statusCode);
        return status;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<EgwStatus> getStatusForModule() {
        List statusList = this.egwStatusDAO.getStatusByModule("Legal Case");
        return statusList;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Position getPositionByName(String name) {
        return this.positionMasterService.getPositionByName(name);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Department getDepartmentByName(String name) {
        return this.departmentService.getDepartmentByName(name);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<BipartisanDetails> getBipartitionList(LegalCase legalcase) {
        return this.legalCaseRepository.getBipartitionDetList(legalcase.getId());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<LegalCaseDocuments> getLegalCaseDocumentList(LegalCase legalcase) {
        List<LegalCaseDocuments> legalDoc = this.legalCaseRepository.getLegalCaseDocumentList(legalcase.getId());
        return legalDoc;
    }
}

