/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.service.AdvocateMasterService;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.CounterAffidavit;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseAdvocate;
import org.egov.lcms.transactions.entity.LegalCaseDepartment;
import org.egov.lcms.transactions.entity.LegalCaseDocuments;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.lcms.transactions.entity.PwrDocuments;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.transactions.repository.PwrDocumentsRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LegalCaseService {
    private final LegalCaseRepository legalCaseRepository;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private PwrDocumentsRepository pwrDocumentsRepository;
    @Autowired
    private AdvocateMasterService advocateMasterService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @Autowired
    public LegalCaseService(LegalCaseRepository legalCaseRepository) {
        this.legalCaseRepository = legalCaseRepository;
    }

    public LegalCase findById(Long Id2) {
        return (LegalCase)((Object)this.legalCaseRepository.findOne(Id2));
    }

    public LegalCase findByLcNumber(String lcnumber) {
        return this.legalCaseRepository.findByLcNumber(lcnumber);
    }

    public LegalCase getLegalCaseByCaseNumber(String caseNumber) {
        return this.legalCaseRepository.findByCaseNumber(caseNumber);
    }

    @Transactional
    public LegalCase persist(LegalCase legalcase) {
        legalcase.setCaseNumber(legalcase.getCaseNumber() + (legalcase.getWpYear() != null ? "/" + legalcase.getWpYear() : ""));
        legalcase.setStatus(this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "LCCREATED"));
        List<LegalCaseDocuments> legalDoc = this.legalCaseUtil.getLegalCaseDocumentList(legalcase);
        legalcase = this.prepareChildEntities(legalcase);
        this.processAndStoreApplicationDocuments(legalcase, legalDoc);
        this.updateNextDate(legalcase, legalcase.getEglcPwrs());
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    @Transactional
    public LegalCase update(LegalCase legalcase) {
        this.updateLegalCaseDeptAndPwr(legalcase, legalcase.getEglcPwrs(), legalcase.getLegalCaseDepartment());
        this.processAndStorePwrDocuments(legalcase);
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    @Transactional
    public void updateLegalCaseDeptAndPwr(LegalCase legalcase, List<Pwr> pwrList, List<LegalCaseDepartment> legalDept) {
        ArrayList<LegalCaseDepartment> legalcaseDetails = new ArrayList<LegalCaseDepartment>(0);
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>(0);
        ArrayList<CounterAffidavit> caListtemp = new ArrayList<CounterAffidavit>(0);
        for (Pwr legalpwr : pwrList) {
            legalpwr.setLegalCase(legalcase);
            legalpwr.setCaFilingdate(new Date());
            pwrListtemp.add(legalpwr);
        }
        legalcase.getEglcPwrs().clear();
        legalcase.setEglcPwrs(pwrListtemp);
        for (CounterAffidavit counterAffidavit : legalcase.getEglcCounterAffidavit()) {
            counterAffidavit.setLegalCase(legalcase);
            caListtemp.add(counterAffidavit);
        }
        legalcase.getEglcCounterAffidavit().clear();
        legalcase.setEglcCounterAffidavit(caListtemp);
        for (LegalCaseDepartment legaldeptObj : legalDept) {
            legaldeptObj.setLegalCase(legalcase);
            legaldeptObj.setPosition(this.legalCaseUtil.getPositionByName(legaldeptObj.getPosition().getName()));
            legaldeptObj.setDepartment(this.legalCaseUtil.getDepartmentByName(legaldeptObj.getDepartment().getName()));
            legalcaseDetails.add(legaldeptObj);
        }
        legalcase.getLegalCaseDepartment().clear();
        legalcase.setLegalCaseDepartment(legalcaseDetails);
    }

    public List<LegalCaseDocuments> getLegalCaseDocList(LegalCase legalCase) {
        ArrayList<LegalCaseDocuments> legalDOc = null;
        HashSet<LegalCaseDocuments> legalDOcSet = new HashSet<LegalCaseDocuments>();
        for (LegalCaseDocuments legalDoc : legalCase.getLegalCaseDocuments()) {
            legalDOcSet.add(legalDoc);
        }
        legalDOc = new ArrayList<LegalCaseDocuments>(legalDOcSet);
        return legalDOc;
    }

    public List<PwrDocuments> getPwrDocList(LegalCase legalCase) {
        ArrayList<PwrDocuments> legalPwrDOc = null;
        HashSet<PwrDocuments> legalDOcSet = new HashSet<PwrDocuments>();
        for (PwrDocuments legalDoc1 : legalCase.getEglcPwrs().get(0).getPwrDocuments()) {
            legalDOcSet.add(legalDoc1);
        }
        legalPwrDOc = new ArrayList<PwrDocuments>(legalDOcSet);
        return legalPwrDOc;
    }

    public LegalCase prepareChildEntities(LegalCase legalcase) {
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>();
        legalcase.getBipartisanDetails().clear();
        if (legalcase != null) {
            for (BipartisanDetails bipartObj : legalcase.getBipartisanPetitionerDetailsList()) {
                if (bipartObj.getName() == null || "".equals(bipartObj.getName())) continue;
                bipartObj.setSerialNumber(bipartObj.getSerialNumber() != null ? bipartObj.getSerialNumber() : 111L);
                bipartObj.setIsRepondent(Boolean.FALSE);
                if (bipartObj.getIsRespondentGovernment() == null) {
                    bipartObj.setIsRespondentGovernment(Boolean.FALSE);
                }
                bipartObj.setLegalCase(legalcase);
                legalcase.getBipartisanDetails().add(bipartObj);
            }
        }
        for (BipartisanDetails bipartObjtemp : legalcase.getBipartisanRespondentDetailsList()) {
            if (bipartObjtemp.getId() != null && bipartObjtemp.getId() == null || bipartObjtemp.getName() == null || "".equals(bipartObjtemp.getName())) continue;
            bipartObjtemp.setSerialNumber(bipartObjtemp.getSerialNumber() != null ? bipartObjtemp.getSerialNumber() : 111L);
            bipartObjtemp.setLegalCase(legalcase);
            if (bipartObjtemp.getIsRespondentGovernment() == null) {
                bipartObjtemp.setIsRespondentGovernment(Boolean.FALSE);
            }
            bipartObjtemp.setIsRepondent(Boolean.TRUE);
            legalcase.getBipartisanDetails().add(bipartObjtemp);
        }
        LinkedHashSet<BipartisanDetails> uniqueSet = new LinkedHashSet<BipartisanDetails>(legalcase.getBipartisanDetails());
        legalcase.getBipartisanDetails().clear();
        legalcase.getBipartisanDetails().addAll(uniqueSet);
        if (!legalcase.getEglcPwrs().isEmpty()) {
            for (Pwr legalpwr : legalcase.getEglcPwrs()) {
                legalpwr.setLegalCase(legalcase);
                pwrListtemp.add(legalpwr);
            }
            legalcase.getEglcPwrs().clear();
            legalcase.setEglcPwrs(pwrListtemp);
        }
        return legalcase;
    }

    @Transactional
    public LegalCase saveStandingCouncilEntity(LegalCaseAdvocate legalCaseAdvocate) {
        LegalCaseAdvocate legalCaseAdvocatetemp = null;
        AdvocateMaster seniorLegalMaster = null;
        AdvocateMaster advocateName = this.advocateMasterService.findByName(legalCaseAdvocate.getAdvocateMaster().getName());
        if (legalCaseAdvocate.getEglcSeniorAdvocateMaster().getName() != null) {
            seniorLegalMaster = this.advocateMasterService.findByName(legalCaseAdvocate.getEglcSeniorAdvocateMaster().getName());
        }
        if (!legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().isEmpty()) {
            legalCaseAdvocatetemp = legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().get(0);
            legalCaseAdvocatetemp.setAdvocateMaster(advocateName);
            legalCaseAdvocatetemp.setAssignedtodate(legalCaseAdvocate.getAssignedtodate());
            legalCaseAdvocatetemp.setVakalatdate(legalCaseAdvocate.getVakalatdate());
            legalCaseAdvocatetemp.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocatetemp.setIsActive(Boolean.TRUE);
            legalCaseAdvocatetemp.setChangeAdvocate(legalCaseAdvocate.getChangeAdvocate());
            legalCaseAdvocatetemp.setChangeSeniorAdvocate(legalCaseAdvocate.getChangeSeniorAdvocate());
            legalCaseAdvocatetemp.setEglcSeniorAdvocateMaster(seniorLegalMaster);
            legalCaseAdvocatetemp.setAssignedtodateForsenior(legalCaseAdvocate.getAssignedtodateForsenior());
            legalCaseAdvocatetemp.setOrderdate(legalCaseAdvocate.getOrderdate());
            legalCaseAdvocatetemp.setOrdernumber(legalCaseAdvocate.getOrdernumber());
            legalCaseAdvocatetemp.setOrderdateJunior(legalCaseAdvocate.getOrderdateJunior());
            legalCaseAdvocatetemp.setOrdernumberJunior(legalCaseAdvocate.getOrdernumberJunior());
            legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().add(legalCaseAdvocatetemp);
        } else {
            legalCaseAdvocate.setAdvocateMaster(advocateName);
            legalCaseAdvocate.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocate.setEglcSeniorAdvocateMaster(seniorLegalMaster);
            legalCaseAdvocate.setIsActive(Boolean.TRUE);
            legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().add(legalCaseAdvocate);
        }
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalCaseAdvocate.getLegalCase()));
    }

    public void processAndStoreApplicationDocuments(LegalCase legalcase, List<LegalCaseDocuments> legalDoc) {
        if (legalcase.getId() == null) {
            if (!legalcase.getLegalCaseDocuments().isEmpty()) {
                for (LegalCaseDocuments applicationDocument : legalcase.getLegalCaseDocuments()) {
                    applicationDocument.setLegalCase(legalcase);
                    applicationDocument.setDocumentName("LegalCase");
                    applicationDocument.setSupportDocs(this.addToFileStore(applicationDocument.getFiles()));
                }
            }
        } else {
            for (LegalCaseDocuments applicationDocument : legalcase.getLegalCaseDocuments()) {
                applicationDocument.setLegalCase(legalcase);
                applicationDocument.setDocumentName("LegalCase");
                applicationDocument.getSupportDocs().addAll(this.addToFileStore(applicationDocument.getFiles()));
                legalcase.getLegalCaseDocuments().clear();
                legalcase.getLegalCaseDocuments().add(applicationDocument);
            }
            legalcase.getLegalCaseDocuments().addAll(legalDoc);
        }
    }

    @Transactional
    public void processAndStorePwrDocuments(LegalCase legalcase) {
        ArrayList<PwrDocuments> pwrDocList = new ArrayList<PwrDocuments>();
        if (!legalcase.getEglcPwrs().get(0).getPwrDocuments().isEmpty()) {
            for (PwrDocuments pwr : legalcase.getEglcPwrs().get(0).getPwrDocuments()) {
                if (pwr == null || pwr.getId() != null) continue;
                pwr.setPwr(legalcase.getEglcPwrs().get(0));
                pwr.setDocumentName("Pwr");
                pwr.setSupportDocs(this.addToFileStore(pwr.getFiles()));
                pwrDocList.add(pwr);
                this.pwrDocumentsRepository.save((Object)pwr);
            }
        }
    }

    protected Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "LCMS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }

    @Transactional
    public LegalCase save(LegalCase legalcase) {
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    public void updateNextDate(LegalCase legalCase, List<Pwr> pwr) {
        if (pwr.get(0).getCaFilingdate() != null) {
            legalCase.setNextDate(pwr.get(0).getCaFilingdate());
        } else if (pwr.get(0).getCaDueDate() != null) {
            legalCase.setNextDate(pwr.get(0).getCaDueDate());
        } else if (pwr.get(0).getPwrDueDate() != null) {
            legalCase.setNextDate(pwr.get(0).getPwrDueDate());
        } else {
            legalCase.setNextDate(legalCase.getCaseDate());
        }
    }
}

