/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.repository.HearingsRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class HearingsService {
    @Autowired
    private HearingsRepository hearingsRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @Transactional
    public Hearings persist(Hearings hearings) {
        this.updateNextDate(hearings, hearings.getLegalCase());
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "IN_PROGRESS");
        hearings.setStatus(statusObj);
        hearings.getLegalCase().setStatus(statusObj);
        return (Hearings)((Object)this.hearingsRepository.save((Object)hearings));
    }

    public List<Hearings> findAll() {
        return this.hearingsRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public Hearings findById(Long id) {
        return (Hearings)((Object)this.hearingsRepository.findOne(id));
    }

    public List<Hearings> findBYLcNumber(String lcNumber) {
        return this.hearingsRepository.findByLegalCase_lcNumber(lcNumber);
    }

    public void updateNextDate(Hearings hearings, LegalCase legalCase) {
        if (!DateUtils.compareDates((Date)legalCase.getNextDate(), (Date)hearings.getHearingDate())) {
            legalCase.setNextDate(hearings.getHearingDate());
        } else {
            ArrayList<Date> hearingDateList = new ArrayList<Date>(0);
            hearingDateList.add(hearings.getHearingDate());
            for (Hearings hearingsObj : legalCase.getHearings()) {
                if (hearingsObj.getId().equals(hearings.getId())) continue;
                hearingDateList.add(hearingsObj.getHearingDate());
            }
            legalCase.setNextDate((Date)Collections.max(hearingDateList));
        }
    }
}

