/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.LegalCaseDepartment;

@Entity
@Table(name="EGLC_REMINDER")
@SequenceGenerator(name="SEQ_EGLC_REMINDER", sequenceName="SEQ_EGLC_REMINDER", allocationSize=1)
public class Reminder
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_REMINDER = "SEQ_EGLC_REMINDER";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_REMINDER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @Valid
    @JoinColumn(name="LEGALCASEDEPT", nullable=false)
    private LegalCaseDepartment legalCaseDepartment;
    private String remarks;
    private Date date;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

    public LegalCaseDepartment getLegalCaseDepartment() {
        return this.legalCaseDepartment;
    }

    public void setLegalCaseDepartment(LegalCaseDepartment legalCaseDepartment) {
        this.legalCaseDepartment = legalCaseDepartment;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getFormattedDate() {
        return this.sdf.format(this.date);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.legalCaseDepartment != null && this.legalCaseDepartment.getDateofreceiptofpwr() != null && !this.getDate().before(this.legalCaseDepartment.getDateofreceiptofpwr())) {
            errors.add(new ValidationError("date", "date.less.receiptOfPwr", new String[]{this.getFormattedDate(), this.sdf.format(this.legalCaseDepartment.getDateofreceiptofpwr())}));
        } else if (this.legalCaseDepartment != null && this.legalCaseDepartment.getLegalCase().getCasedate() != null && !this.getDate().after(this.legalCaseDepartment.getLegalCase().getCasedate())) {
            errors.add(new ValidationError("date", "date.greater.casedate", new String[]{this.getFormattedDate(), this.sdf.format(this.legalCaseDepartment.getLegalCase().getCasedate())}));
        }
        return errors;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

