/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.enums.ImplementationFailure;
import org.egov.lcms.masters.entity.enums.JudgmentImplIsComplied;
import org.egov.lcms.transactions.entity.Appeal;
import org.egov.lcms.transactions.entity.Contempt;
import org.egov.lcms.transactions.entity.Judgment;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_JUDGMENTIMPL")
@SequenceGenerator(name="SEQ_EGLC_JUDGMENTIMPL", sequenceName="SEQ_EGLC_JUDGMENTIMPL", allocationSize=1)
public class JudgmentImpl
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_JUDGMENTIMPL = "SEQ_EGLC_JUDGMENTIMPL";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_JUDGMENTIMPL", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="judgment", nullable=false)
    private Judgment judgment;
    @Enumerated(value=EnumType.STRING)
    @Column(name="iscompiled")
    private JudgmentImplIsComplied judgmentImplIsComplied;
    @Temporal(value=TemporalType.DATE)
    @Column(name="dateofcompliance")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.compliance.date")
    private Date dateOfCompliance;
    @Length(max=1024)
    @Column(name="compliancereport")
    private String complianceReport;
    @Enumerated(value=EnumType.STRING)
    @Column(name="reason")
    private ImplementationFailure implementationFailure;
    @Length(max=128)
    @Column(name="implementationdetails")
    private String details;
    @OneToMany(mappedBy="judgmentImpl", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Contempt> contempt = new ArrayList<Contempt>(0);
    @OneToMany(mappedBy="judgmentImpl", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<Appeal> appeal = new ArrayList<Appeal>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Contempt> getContempt() {
        return this.contempt;
    }

    public void setContempt(List<Contempt> contempt) {
        this.contempt = contempt;
    }

    public List<Appeal> getAppeal() {
        return this.appeal;
    }

    public void setAppeal(List<Appeal> appeal) {
        this.appeal = appeal;
    }

    public Judgment getJudgment() {
        return this.judgment;
    }

    public void setJudgment(Judgment judgment) {
        this.judgment = judgment;
    }

    public JudgmentImplIsComplied getJudgmentImplIsComplied() {
        return this.judgmentImplIsComplied;
    }

    public void setJudgmentImplIsComplied(JudgmentImplIsComplied judgmentImplIsComplied) {
        this.judgmentImplIsComplied = judgmentImplIsComplied;
    }

    public ImplementationFailure getImplementationFailure() {
        return this.implementationFailure;
    }

    public void setImplementationFailure(ImplementationFailure implementationFailure) {
        this.implementationFailure = implementationFailure;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Date getDateOfCompliance() {
        return this.dateOfCompliance;
    }

    public void setDateOfCompliance(Date dateOfCompliance) {
        this.dateOfCompliance = dateOfCompliance;
    }

    public String getComplianceReport() {
        return this.complianceReport;
    }

    public void setComplianceReport(String complianceReport) {
        this.complianceReport = complianceReport;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getDateOfCompliance() != null && !DateUtils.compareDates((Date)this.getDateOfCompliance(), (Date)this.judgment.getOrderDate())) {
            errors.add(new ValidationError("dateofcompliance", "dateofcompliance.less.orderDate"));
        }
        for (Contempt contempt : this.getContempt()) {
            errors.addAll(contempt.validate());
        }
        for (Appeal appeal : this.getAppeal()) {
            errors.addAll(appeal.validate());
        }
        return errors;
    }
}

