/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_CONTEMPT")
@SequenceGenerator(name="SEQ_EGLC_CONTEMPT", sequenceName="SEQ_EGLC_CONTEMPT", allocationSize=1)
public class Contempt
extends AbstractPersistable<Long> {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_CONTEMPT = "SEQ_EGLC_CONTEMPT";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_CONTEMPT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @NotNull
    @JoinColumn(name="judgmentimpl")
    private JudgmentImpl judgmentImpl;
    @Length(max=50)
    @NotNull
    @Column(name="canumber")
    private String caNumber;
    @Temporal(value=TemporalType.DATE)
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy")
    @Column(name="receivingdate")
    private Date receivingDate;
    @Column(name="iscommapprrequired")
    private Boolean iscommapprRequired = false;
    @Temporal(value=TemporalType.DATE)
    @Column(name="commappdate")
    private Date commappDate;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public JudgmentImpl getJudgmentImpl() {
        return this.judgmentImpl;
    }

    public void setJudgmentImpl(JudgmentImpl judgmentImpl) {
        this.judgmentImpl = judgmentImpl;
    }

    public boolean getIscommapprRequired() {
        return this.iscommapprRequired;
    }

    public void setIscommapprRequired(boolean iscommapprRequired) {
        this.iscommapprRequired = iscommapprRequired;
    }

    public Date getCommappDate() {
        return this.commappDate;
    }

    public void setCommappDate(Date commappDate) {
        this.commappDate = commappDate;
    }

    public String getCaNumber() {
        return this.caNumber;
    }

    public void setCaNumber(String caNumber) {
        this.caNumber = caNumber;
    }

    public Date getReceivingDate() {
        return this.receivingDate;
    }

    public void setReceivingDate(Date receivingDate) {
        this.receivingDate = receivingDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getReceivingDate() != null) {
            if (!DateUtils.compareDates((Date)this.getReceivingDate(), (Date)this.getJudgmentImpl().getJudgment().getOrderDate())) {
                errors.add(new ValidationError("receivingDate", "receivingDate.less.orderDate"));
            }
            if (!DateUtils.compareDates((Date)this.getCommappDate(), (Date)this.getReceivingDate())) {
                errors.add(new ValidationError("receivingDate", "commappDate.greaterThan.receivingDate"));
            }
        }
        return errors;
    }
}

