/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.lcms.masters.entity.CourtMaster;
import org.egov.lcms.masters.entity.CourtTypeMaster;
import org.egov.lcms.masters.repository.CourtMasterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CourtMasterService {
    private final CourtMasterRepository courtMasterRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CourtMasterService(CourtMasterRepository courtMasterRepository) {
        this.courtMasterRepository = courtMasterRepository;
    }

    @Transactional
    public CourtMaster persist(CourtMaster courtMaster) {
        return (CourtMaster)((Object)this.courtMasterRepository.save((Object)courtMaster));
    }

    public List<CourtMaster> findAll() {
        return this.courtMasterRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CourtMaster findByName(String name) {
        return this.courtMasterRepository.findByName(name);
    }

    public CourtMaster findOne(Long id) {
        return (CourtMaster)((Object)this.courtMasterRepository.findOne(id));
    }

    public List<CourtMaster> findActiveCourtByCourtType(CourtTypeMaster courtType) {
        return this.courtMasterRepository.findByActiveTrueAndCourtType(courtType);
    }

    public List<CourtMaster> getActiveCourtMaster() {
        return this.courtMasterRepository.findByActiveTrueOrderByNameAsc();
    }

    public List<CourtMaster> search(CourtMaster courtMaster) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(CourtMaster.class);
        Root courtMasterobj = createQuery.from(CourtMaster.class);
        createQuery.select((Selection)courtMasterobj);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType CourtMaster2 = m.entity(CourtMaster.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (courtMaster.getName() == null && courtMaster.getCourtType() == null && courtMaster.getActive() == null) {
            resultList = this.findAll();
        } else {
            if (courtMaster.getName() != null) {
                String name = "%" + courtMaster.getName().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)courtMasterobj.get("name")));
                predicates.add(cb.like(cb.lower((Expression)courtMasterobj.get(CourtMaster2.getDeclaredSingularAttribute("name", String.class))), name));
            }
            if (courtMaster.getCourtType() != null) {
                predicates.add(cb.equal((Expression)courtMasterobj.get("courtType"), (Object)courtMaster.getCourtType()));
            }
            if (courtMaster.getActive() != null) {
                if (courtMaster.getActive().booleanValue()) {
                    predicates.add(cb.equal((Expression)courtMasterobj.get(CourtMaster2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)true));
                } else {
                    predicates.add(cb.equal((Expression)courtMasterobj.get(CourtMaster2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)false));
                }
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }
}

