/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.repository.AdvocateMasterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvocateMasterService {
    private final AdvocateMasterRepository advocateMasterRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;

    @Autowired
    public AdvocateMasterService(AdvocateMasterRepository advocateMasterRepository) {
        this.advocateMasterRepository = advocateMasterRepository;
    }

    @Transactional
    public AdvocateMaster persist(AdvocateMaster advocateMaster) {
        return (AdvocateMaster)((Object)this.advocateMasterRepository.save((Object)advocateMaster));
    }

    public List<AdvocateMaster> findAll() {
        return this.advocateMasterRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public AdvocateMaster findByName(String name) {
        return this.advocateMasterRepository.findByName(name);
    }

    public List<AdvocateMaster> getAllAdvocatesByNameLikeAndIsSeniorAdvocate(String name, Boolean isSeniorAdvocate) {
        return this.advocateMasterRepository.findByNameContainingIgnoreCaseAndIsSeniorAdvocate(name, isSeniorAdvocate);
    }

    public AdvocateMaster findOne(Long id) {
        return (AdvocateMaster)((Object)this.advocateMasterRepository.findOne(id));
    }

    @Transactional
    public void createAccountDetailKey(AdvocateMaster ad) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("lawyer");
        Accountdetailkey accountdetailkey = new Accountdetailkey();
        accountdetailkey.setGroupid(Integer.valueOf(1));
        accountdetailkey.setDetailkey(Integer.valueOf(ad.getId().intValue()));
        accountdetailkey.setDetailname(accountdetailtype.getAttributename());
        accountdetailkey.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(accountdetailkey);
    }

    public List<AdvocateMaster> search(AdvocateMaster advocateMaster) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(AdvocateMaster.class);
        Root advocateMasterObj = createQuery.from(AdvocateMaster.class);
        createQuery.select((Selection)advocateMasterObj);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType AdvocateMaster2 = m.entity(AdvocateMaster.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (advocateMaster.getName() == null && advocateMaster.getMobileNumber() == null && advocateMaster.getEmail() == null) {
            resultList = this.findAll();
        } else {
            if (advocateMaster.getName() != null) {
                String name = "%" + advocateMaster.getName().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)advocateMasterObj.get("name")));
                predicates.add(cb.like(cb.lower((Expression)advocateMasterObj.get(AdvocateMaster2.getDeclaredSingularAttribute("name", String.class))), name));
            }
            if (advocateMaster.getMobileNumber() != null) {
                String mobileNumber = "%" + advocateMaster.getMobileNumber() + "%";
                predicates.add(cb.isNotNull((Expression)advocateMasterObj.get("mobileNumber")));
                predicates.add(cb.like(cb.lower((Expression)advocateMasterObj.get(AdvocateMaster2.getDeclaredSingularAttribute("mobileNumber", String.class))), mobileNumber));
            }
            if (advocateMaster.getEmail() != null) {
                String email = "%" + advocateMaster.getEmail() + "%";
                predicates.add(cb.isNotNull((Expression)advocateMasterObj.get("email")));
                predicates.add(cb.like(cb.lower((Expression)advocateMasterObj.get(AdvocateMaster2.getDeclaredSingularAttribute("email", String.class))), email));
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }
}

