/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentDocuments;
import org.egov.lcms.transactions.repository.JudgmentRepository;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class JudgmentService {
    @Autowired
    private final JudgmentRepository judgmentRepository;
    @Autowired
    private LegalCaseRepository legalCaseRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @Autowired
    public JudgmentService(JudgmentRepository judgmentRepository) {
        this.judgmentRepository = judgmentRepository;
    }

    @Transactional
    public Judgment persist(Judgment judgment) {
        List<JudgmentDocuments> judgmentDoc = this.legalCaseUtil.getJudgmentDocumentList(judgment);
        this.processAndStoreApplicationDocuments(judgment, judgmentDoc);
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "JUDGMENT");
        judgment.getLegalCase().setStatus(statusObj);
        this.legalCaseRepository.save((Object)judgment.getLegalCase());
        return (Judgment)((Object)this.judgmentRepository.save((Object)judgment));
    }

    public List<Judgment> findAll() {
        return this.judgmentRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public Judgment findById(Long id) {
        return (Judgment)((Object)this.judgmentRepository.findOne(id));
    }

    public List<JudgmentDocuments> getJudgmentDocList(Judgment judgment) {
        return judgment.getJudgmentDocuments();
    }

    protected void processAndStoreApplicationDocuments(Judgment judgment, List<JudgmentDocuments> judgmentDoc) {
        if (judgment.getId() == null) {
            if (!judgment.getJudgmentDocuments().isEmpty()) {
                for (JudgmentDocuments applicationDocument : judgment.getJudgmentDocuments()) {
                    applicationDocument.setJudgment(judgment);
                    applicationDocument.setDocumentName("Judgment");
                    applicationDocument.setSupportDocs(this.legalCaseUtil.addToFileStore(applicationDocument.getFiles()));
                }
            }
        } else {
            ArrayList<JudgmentDocuments> tempJudgmentDoc = new ArrayList<JudgmentDocuments>(judgment.getJudgmentDocuments());
            for (JudgmentDocuments applicationDocument : tempJudgmentDoc) {
                applicationDocument.setJudgment(judgment);
                applicationDocument.setDocumentName("Judgment");
                applicationDocument.getSupportDocs().addAll(this.legalCaseUtil.addToFileStore(applicationDocument.getFiles()));
                judgment.getJudgmentDocuments().add(applicationDocument);
            }
            judgment.getJudgmentDocuments().addAll(judgmentDoc);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Judgment findByLCNumber(String lcNumber) {
        return this.judgmentRepository.findByLegalCase_lcNumber(lcNumber);
    }

    public void updateNextDate(Judgment judgment) {
        Date nextDate;
        Date date = nextDate = judgment.getEnquiryDate() != null ? judgment.getEnquiryDate() : judgment.getOrderDate();
        if (!DateUtils.compareDates((Date)judgment.getLegalCase().getNextDate(), (Date)nextDate)) {
            judgment.getLegalCase().setNextDate(nextDate);
        } else if (judgment.getEnquiryDate() != null) {
            judgment.getLegalCase().setNextDate(judgment.getEnquiryDate());
        } else {
            judgment.getLegalCase().setNextDate(judgment.getOrderDate());
        }
    }
}

