/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.lcms.masters.entity.CourtTypeMaster;
import org.egov.lcms.masters.entity.PetitionTypeMaster;
import org.egov.lcms.masters.repository.PetitionTypeMasterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PetitionTypeMasterService {
    private final PetitionTypeMasterRepository petitionTypeMasterRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public PetitionTypeMasterService(PetitionTypeMasterRepository petitionTypeMasterRepository) {
        this.petitionTypeMasterRepository = petitionTypeMasterRepository;
    }

    @Transactional
    public PetitionTypeMaster create(PetitionTypeMaster petitionTypeMaster) {
        return (PetitionTypeMaster)((Object)this.petitionTypeMasterRepository.save((Object)petitionTypeMaster));
    }

    @Transactional
    public PetitionTypeMaster update(PetitionTypeMaster petitionTypeMaster) {
        return (PetitionTypeMaster)((Object)this.petitionTypeMasterRepository.save((Object)petitionTypeMaster));
    }

    public List<PetitionTypeMaster> findAll() {
        return this.petitionTypeMasterRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"petitionType"}));
    }

    public PetitionTypeMaster findByCode(String code) {
        return this.petitionTypeMasterRepository.findByCode(code);
    }

    public PetitionTypeMaster findOne(Long id) {
        return (PetitionTypeMaster)((Object)this.petitionTypeMasterRepository.findOne(id));
    }

    public List<PetitionTypeMaster> findActivePetitionByCourtType(CourtTypeMaster courtType) {
        return this.petitionTypeMasterRepository.findByActiveTrueAndCourtType(courtType);
    }

    public List<PetitionTypeMaster> search(PetitionTypeMaster petitionTypeMaster) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(PetitionTypeMaster.class);
        Root petitionTypeMasterobj = createQuery.from(PetitionTypeMaster.class);
        createQuery.select((Selection)petitionTypeMasterobj);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType PetitionTypeMaster2 = m.entity(PetitionTypeMaster.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (petitionTypeMaster.getCode() == null && petitionTypeMaster.getCourtType() == null && petitionTypeMaster.getPetitionType() == null && petitionTypeMaster.getActive() == null) {
            resultList = this.findAll();
        } else {
            if (petitionTypeMaster.getCode() != null) {
                String code = "%" + petitionTypeMaster.getCode().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)petitionTypeMasterobj.get("code")));
                predicates.add(cb.like(cb.lower((Expression)petitionTypeMasterobj.get(PetitionTypeMaster2.getDeclaredSingularAttribute("code", String.class))), code));
            }
            if (petitionTypeMaster.getPetitionType() != null) {
                String petitionType = "%" + petitionTypeMaster.getPetitionType().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)petitionTypeMasterobj.get("petitionType")));
                predicates.add(cb.like(cb.lower((Expression)petitionTypeMasterobj.get(PetitionTypeMaster2.getDeclaredSingularAttribute("petitionType", String.class))), petitionType));
            }
            if (petitionTypeMaster.getCourtType() != null) {
                predicates.add(cb.equal((Expression)petitionTypeMasterobj.get("courtType"), (Object)petitionTypeMaster.getCourtType()));
            }
            if (petitionTypeMaster.getActive() != null) {
                if (petitionTypeMaster.getActive().booleanValue()) {
                    predicates.add(cb.equal((Expression)petitionTypeMasterobj.get(PetitionTypeMaster2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)true));
                } else {
                    predicates.add(cb.equal((Expression)petitionTypeMasterobj.get(PetitionTypeMaster2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)false));
                }
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }

    public List<PetitionTypeMaster> getPetitiontypeList() {
        return this.petitionTypeMasterRepository.findAll();
    }

    public List<PetitionTypeMaster> getActivePetitionTypes() {
        return this.petitionTypeMasterRepository.findByActiveTrueOrderByPetitionTypeAsc();
    }
}

