/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.lcms.reports.entity.LegalCaseSearchResult;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SearchLegalCaseService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<LegalCaseSearchResult> getLegalCaseReport(LegalCaseSearchResult legalCaseSearchResultOblj) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct legalObj  as  legalCase ,courtmaster.name  as  courtName ,");
        queryStr.append(" egwStatus.code  as  caseStatus ");
        queryStr.append(" from LegalCase legalObj,CourtMaster courtmaster,CaseTypeMaster casetypemaster,");
        queryStr.append(" PetitionTypeMaster petmaster,EgwStatus egwStatus");
        queryStr.append(" where legalObj.courtMaster.id=courtmaster.id and ");
        queryStr.append(" legalObj.caseTypeMaster.id=casetypemaster.id and legalObj.petitionTypeMaster.id=petmaster.id and ");
        queryStr.append(" legalObj.status.id=egwStatus.id and egwStatus.moduletype =:mdoculeType ");
        this.getAppendQuery(legalCaseSearchResultOblj, queryStr);
        Query queryResult = this.getCurrentSession().createQuery(queryStr.toString());
        queryResult = this.setParametersToQuery(legalCaseSearchResultOblj, queryResult);
        List legalcaseSearchList = queryResult.list();
        return legalcaseSearchList;
    }

    private Query setParametersToQuery(LegalCaseSearchResult legalCaseSearchResultOblj, Query queryResult) {
        queryResult.setString("mdoculeType", "Legal Case");
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getLcNumber())) {
            queryResult.setString("lcNumber", legalCaseSearchResultOblj.getLcNumber());
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getCaseNumber())) {
            queryResult.setString("caseNumber", legalCaseSearchResultOblj.getCaseNumber() + "%");
        }
        if (legalCaseSearchResultOblj.getCourtId() != null) {
            queryResult.setInteger("court", legalCaseSearchResultOblj.getCourtId().intValue());
        }
        if (legalCaseSearchResultOblj.getCasecategory() != null) {
            queryResult.setInteger("casetype", legalCaseSearchResultOblj.getCasecategory().intValue());
        }
        if (legalCaseSearchResultOblj.getCourtType() != null) {
            queryResult.setInteger("courttype", legalCaseSearchResultOblj.getCourtType().intValue());
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getStandingCouncil())) {
            queryResult.setString("standingcoouncil", legalCaseSearchResultOblj.getStandingCouncil() + "%");
        }
        if (legalCaseSearchResultOblj.getStatusId() != null) {
            queryResult.setInteger("status", legalCaseSearchResultOblj.getStatusId().intValue());
        }
        if (legalCaseSearchResultOblj.getCaseFromDate() != null) {
            queryResult.setDate("fromdate", legalCaseSearchResultOblj.getCaseFromDate());
        }
        if (legalCaseSearchResultOblj.getCaseToDate() != null) {
            queryResult.setDate("toDate", legalCaseSearchResultOblj.getCaseToDate());
        }
        if (legalCaseSearchResultOblj.getPetitionTypeId() != null) {
            queryResult.setInteger("petiontionType", legalCaseSearchResultOblj.getPetitionTypeId().intValue());
        }
        if (legalCaseSearchResultOblj.getIsStatusExcluded() != null) {
            ArrayList<String> statusCodeList = new ArrayList<String>();
            statusCodeList.add("CLOSED");
            statusCodeList.add("JUDGEMENT_IMPL");
            queryResult.setParameterList("statusCodeList", statusCodeList);
        }
        queryResult.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(LegalCaseSearchResult.class));
        return queryResult;
    }

    private void getAppendQuery(LegalCaseSearchResult legalCaseSearchResultOblj, StringBuilder queryStr) {
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getLcNumber())) {
            queryStr.append(" and legalObj.lcNumber =:lcNumber");
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getCaseNumber())) {
            queryStr.append(" and legalObj.caseNumber like :caseNumber ");
        }
        if (legalCaseSearchResultOblj.getCourtId() != null) {
            queryStr.append(" and courtmaster.id =:court ");
        }
        if (legalCaseSearchResultOblj.getCasecategory() != null) {
            queryStr.append(" and casetypemaster.id =:casetype");
        }
        if (legalCaseSearchResultOblj.getCourtType() != null) {
            queryStr.append(" and courtmaster.id =:courttype ");
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getStandingCouncil())) {
            queryStr.append(" and legalObj.oppPartyAdvocate like :standingcoouncil ");
        }
        if (legalCaseSearchResultOblj.getStatusId() != null) {
            queryStr.append(" and egwStatus.id =:status ");
        }
        if (legalCaseSearchResultOblj.getCaseFromDate() != null) {
            queryStr.append(" and legalObj.caseDate >=:fromdate ");
        }
        if (legalCaseSearchResultOblj.getCaseToDate() != null) {
            queryStr.append(" and legalObj.caseDate <=:toDate ");
        }
        if (legalCaseSearchResultOblj.getPetitionTypeId() != null) {
            queryStr.append(" and petmaster.id =:petiontionType ");
        }
        if (legalCaseSearchResultOblj.getIsStatusExcluded() != null) {
            queryStr.append(" and egwStatus.code not in (:statusCodeList ) ");
        }
    }
}

