/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.transactions.entity.LcInterimOrderDocuments;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.repository.LegalCaseInterimOrderRepository;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LegalCaseInterimOrderService {
    private final LegalCaseInterimOrderRepository legalCaseInterimOrderRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private LegalCaseRepository legalCaseRepository;

    @Autowired
    public LegalCaseInterimOrderService(LegalCaseInterimOrderRepository legalCaseInterimOrderRepository) {
        this.legalCaseInterimOrderRepository = legalCaseInterimOrderRepository;
    }

    @Transactional
    public LegalCaseInterimOrder persist(LegalCaseInterimOrder legalCaseInterimOrder) {
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "IN_PROGRESS");
        this.updateNextDate(legalCaseInterimOrder, legalCaseInterimOrder.getLegalCase());
        legalCaseInterimOrder.getLegalCase().setStatus(statusObj);
        List<LcInterimOrderDocuments> interiomOrderDoc = this.legalCaseUtil.getLcInterimOrderDocumentList(legalCaseInterimOrder);
        this.processAndStoreApplicationDocuments(legalCaseInterimOrder, interiomOrderDoc);
        this.legalCaseRepository.save((Object)legalCaseInterimOrder.getLegalCase());
        return (LegalCaseInterimOrder)((Object)this.legalCaseInterimOrderRepository.save((Object)legalCaseInterimOrder));
    }

    public List<LegalCaseInterimOrder> findAll() {
        return this.legalCaseInterimOrderRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"id"}));
    }

    public LegalCaseInterimOrder findById(Long id) {
        return this.legalCaseInterimOrderRepository.findById(id);
    }

    public List<LcInterimOrderDocuments> getLcInterimOrderDocList(LegalCaseInterimOrder legalCaseInterimOrder) {
        return legalCaseInterimOrder.getLcInterimOrderDocuments();
    }

    protected void processAndStoreApplicationDocuments(LegalCaseInterimOrder legalCaseInterimOrder, List<LcInterimOrderDocuments> interimOrderDoc) {
        if (legalCaseInterimOrder.getId() == null) {
            if (!legalCaseInterimOrder.getLcInterimOrderDocuments().isEmpty()) {
                for (LcInterimOrderDocuments applicationDocument : legalCaseInterimOrder.getLcInterimOrderDocuments()) {
                    applicationDocument.setLegalCaseInterimOrder(legalCaseInterimOrder);
                    applicationDocument.setDocumentName("LcInterimOrder");
                    applicationDocument.setSupportDocs(this.legalCaseUtil.addToFileStore(applicationDocument.getFiles()));
                }
            }
        } else {
            ArrayList<LcInterimOrderDocuments> tempLcInterimDoc = new ArrayList<LcInterimOrderDocuments>(legalCaseInterimOrder.getLcInterimOrderDocuments());
            for (LcInterimOrderDocuments applicationDocument : tempLcInterimDoc) {
                applicationDocument.setLegalCaseInterimOrder(legalCaseInterimOrder);
                applicationDocument.setDocumentName("LcInterimOrder");
                applicationDocument.getSupportDocs().addAll(this.legalCaseUtil.addToFileStore(applicationDocument.getFiles()));
                legalCaseInterimOrder.getLcInterimOrderDocuments().add(applicationDocument);
            }
            legalCaseInterimOrder.getLcInterimOrderDocuments().addAll(interimOrderDoc);
        }
    }

    public List<LegalCaseInterimOrder> findByLCNumber(String lcNumber) {
        return this.legalCaseInterimOrderRepository.findByLegalCase_lcNumber(lcNumber);
    }

    public void updateNextDate(LegalCaseInterimOrder legalCaseInterimOrder, LegalCase legalCase) {
        if (!DateUtils.compareDates((Date)legalCase.getNextDate(), (Date)legalCaseInterimOrder.getIoDate())) {
            legalCase.setNextDate(legalCaseInterimOrder.getIoDate());
        } else {
            ArrayList<Date> ioDateList = new ArrayList<Date>(0);
            ioDateList.add(legalCaseInterimOrder.getIoDate());
            for (LegalCaseInterimOrder lcinterimorderObj : legalCase.getLegalCaseInterimOrder()) {
                if (lcinterimorderObj.getId().equals(legalCaseInterimOrder.getId())) continue;
                ioDateList.add(lcinterimorderObj.getIoDate());
            }
            legalCase.setNextDate((Date)Collections.max(ioDateList));
        }
    }
}

