/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.lcms.transactions.entity.Appeal;
import org.egov.lcms.transactions.entity.AppealDocuments;
import org.egov.lcms.transactions.entity.Contempt;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.repository.AppealDocumentsRepository;
import org.egov.lcms.transactions.repository.JudgmentImplRepository;
import org.egov.lcms.transactions.service.LegalCaseService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class JudgmentImplService {
    private final JudgmentImplRepository judgmentImplRepository;
    @Autowired
    private AppealDocumentsRepository appealDocumentsRepository;
    @Autowired
    private LegalCaseService legalCaseService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @Autowired
    public JudgmentImplService(JudgmentImplRepository judgmentImplRepository) {
        this.judgmentImplRepository = judgmentImplRepository;
    }

    @Transactional
    public JudgmentImpl persist(JudgmentImpl judgmentImpl) {
        this.persistAppealOrContempt(judgmentImpl);
        if (judgmentImpl.getImplementationFailure() != null && judgmentImpl.getImplementationFailure().toString().equals("Appeal")) {
            this.processAndStoreAppealDocuments(judgmentImpl);
        }
        return (JudgmentImpl)((Object)this.judgmentImplRepository.save((Object)judgmentImpl));
    }

    @Transactional
    public void saveOrUpdate(JudgmentImpl judgmentImpl) {
        this.persist(judgmentImpl);
        if (judgmentImpl.getJudgment().getImplementByDate() != null) {
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getJudgment().getImplementByDate());
        } else {
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getJudgment().getOrderDate());
        }
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "JUDGEMENT_IMPL");
        judgmentImpl.getJudgment().getLegalCase().setStatus(statusObj);
        judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getDateOfCompliance());
        this.legalCaseService.save(judgmentImpl.getJudgment().getLegalCase());
    }

    @Transactional
    public void persistAppealOrContempt(JudgmentImpl judgmentImpl) {
        if (judgmentImpl.getContempt().get(0).getCaNumber() != null) {
            for (Contempt contemptObj : judgmentImpl.getContempt()) {
                contemptObj.setJudgmentImpl(judgmentImpl);
            }
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getContempt().get(0).getReceivingDate());
            judgmentImpl.getAppeal().clear();
        } else if (judgmentImpl.getAppeal().get(0).getSrNumber() != null) {
            for (Appeal appealObj : judgmentImpl.getAppeal()) {
                if (appealObj.getSrNumber() == null || "".equals(appealObj.getSrNumber())) continue;
                appealObj.setJudgmentImpl(judgmentImpl);
            }
            judgmentImpl.getJudgment().getLegalCase().setNextDate(judgmentImpl.getAppeal().get(0).getAppealFiledOn());
            judgmentImpl.getContempt().clear();
        } else {
            judgmentImpl.getAppeal().clear();
            judgmentImpl.getContempt().clear();
        }
    }

    public List<AppealDocuments> getAppealDocList(JudgmentImpl judgmentImpl) {
        ArrayList<AppealDocuments> judgmentImplAppealDOc = new ArrayList<AppealDocuments>();
        HashSet<AppealDocuments> appealDOcSet = new HashSet<AppealDocuments>();
        if (!judgmentImpl.getAppeal().isEmpty() && judgmentImpl.getAppeal().get(0) != null) {
            for (AppealDocuments appealDocs : judgmentImpl.getAppeal().get(0).getAppealDocuments()) {
                appealDOcSet.add(appealDocs);
            }
            judgmentImplAppealDOc.addAll(appealDOcSet);
        }
        return judgmentImplAppealDOc;
    }

    @Transactional
    public void processAndStoreAppealDocuments(JudgmentImpl judgmentImpl) {
        ArrayList<AppealDocuments> appealDocList = new ArrayList<AppealDocuments>();
        if (!judgmentImpl.getAppeal().get(0).getAppealDocuments().isEmpty()) {
            for (AppealDocuments appealDocument : judgmentImpl.getAppeal().get(0).getAppealDocuments()) {
                if (appealDocument.getFiles() == null) continue;
                appealDocument.setAppeal(judgmentImpl.getAppeal().get(0));
                appealDocument.setDocumentName("Appeal");
                appealDocument.setSupportDocs(this.legalCaseUtil.addToFileStore(appealDocument.getFiles()));
                appealDocList.add(appealDocument);
                this.appealDocumentsRepository.save((Object)appealDocument);
            }
        }
    }

    public List<JudgmentImpl> findAll() {
        return this.judgmentImplRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{" "}));
    }

    public JudgmentImpl findOne(Long id) {
        return (JudgmentImpl)((Object)this.judgmentImplRepository.findOne(id));
    }
}

