/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.CaseTypeMaster;
import org.egov.lcms.masters.entity.CourtMaster;
import org.egov.lcms.masters.entity.PetitionTypeMaster;
import org.egov.lcms.masters.entity.enums.LCNumberType;
import org.egov.lcms.transactions.entity.BatchCase;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.CounterAffidavit;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.LegalCaseAdvocate;
import org.egov.lcms.transactions.entity.LegalCaseDepartment;
import org.egov.lcms.transactions.entity.LegalCaseDisposal;
import org.egov.lcms.transactions.entity.LegalCaseDocuments;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.entity.LegalCaseMiscDetails;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.lcms.transactions.entity.Reminder;
import org.egov.pims.commons.Position;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_LEGALCASE")
@SequenceGenerator(name="SEQ_EGLC_LEGALCASE", sequenceName="SEQ_EGLC_LEGALCASE", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class LegalCase
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_LEGALCASE_TYPE = "SEQ_EGLC_LEGALCASE";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LEGALCASE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Temporal(value=TemporalType.DATE)
    @Audited
    private Date nextDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    @JoinColumn(name="CASETYPE", nullable=false)
    @Audited
    private CaseTypeMaster caseTypeMaster;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    @JoinColumn(name="COURT", nullable=false)
    @Audited
    private CourtMaster courtMaster;
    @ManyToOne
    @JoinColumn(name="STATUS", nullable=false)
    @NotAudited
    private EgwStatus status;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    @JoinColumn(name="PETITIONTYPE", nullable=false)
    @Audited
    private PetitionTypeMaster petitionTypeMaster;
    @NotNull
    @Column(name="casenumber", unique=true)
    @Audited
    private String caseNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @Column(name="casedate")
    @Audited
    private Date caseDate;
    @NotNull
    @Length(max=1024)
    @Column(name="casetitle")
    @Audited
    private String caseTitle;
    @Length(max=50)
    @Column(name="appealnum")
    @Audited
    private String appealNum;
    @Length(max=1024)
    @Audited
    private String remarks;
    @Column(name="casereceivingdate")
    @Temporal(value=TemporalType.DATE)
    @Audited
    private Date caseReceivingDate;
    @Audited
    private Boolean isfiledbycorporation;
    @Length(max=50)
    @Column(name="lcnumber")
    @Audited
    private String lcNumber;
    @NotNull
    @Length(max=1024)
    @Audited
    private String prayer;
    @Column(name="isSenioradvrequired")
    @Audited
    private Boolean isSenioradvrequired = Boolean.FALSE;
    @Column(name="assigntoIdboundary")
    @Audited
    private Long assigntoIdboundary;
    @Length(max=128)
    @Column(name="oppPartyAdvocate")
    @Audited
    private String oppPartyAdvocate;
    @Length(max=256)
    @Column(name="representedby")
    @Audited
    private String representedby;
    @Column(name="lcNumberType")
    @Enumerated(value=EnumType.STRING)
    @Audited
    private LCNumberType lcNumberType;
    @Temporal(value=TemporalType.DATE)
    @Column(name="previousDate")
    @Audited
    private Date previousDate;
    @Column(name="stampNumber")
    @Audited
    private String stampNumber;
    @Length(max=50)
    @Column(name="officerincharge")
    @Audited
    private String officerIncharge;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @Column(name="noticedate")
    @Audited
    private Date noticeDate;
    @Temporal(value=TemporalType.DATE)
    @Audited
    private Date casefirstappearancedate;
    @Transient
    private String functionaryCode;
    @Transient
    private String wpYear;
    @Transient
    private String finwpYear;
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private List<Judgment> judgment = new ArrayList<Judgment>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @NotAudited
    private List<LegalCaseDocuments> legalCaseDocuments = new ArrayList<LegalCaseDocuments>();
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private final List<Pwr> pwrList = new ArrayList<Pwr>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private final List<CounterAffidavit> counterAffidavits = new ArrayList<CounterAffidavit>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private List<LegalCaseInterimOrder> legalCaseInterimOrder = new ArrayList<LegalCaseInterimOrder>(0);
    @Audited
    @OrderBy(value="name asc")
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BipartisanDetails> bipartisanDetails = new ArrayList<BipartisanDetails>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="legalCase", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @Audited
    private List<LegalCaseAdvocate> legalCaseAdvocates = new ArrayList<LegalCaseAdvocate>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private List<Hearings> hearings = new ArrayList<Hearings>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Audited
    private List<LegalCaseDisposal> legalCaseDisposal = new ArrayList<LegalCaseDisposal>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Audited
    private final List<LegalCaseDepartment> legalCaseDepartment = new ArrayList<LegalCaseDepartment>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BatchCase> batchCaseSet = new ArrayList<BatchCase>(0);
    @OneToMany(mappedBy="legalCase", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LegalCaseMiscDetails> legalCaseMiscDetails = new ArrayList<LegalCaseMiscDetails>(0);
    @Transient
    @Audited
    @OrderBy(value="name asc")
    private List<BipartisanDetails> bipartisanRespondentDetailsList = new ArrayList<BipartisanDetails>(0);
    @Transient
    @Audited
    @OrderBy(value="name asc")
    private List<BipartisanDetails> bipartisanPetitionerDetailsList = new ArrayList<BipartisanDetails>(0);
    @Transient
    private List<Judgment> judgmentsBeanList = new ArrayList<Judgment>(0);

    public List<ValidationError> validate() {
        AbstractAuditable element;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getIsfiledbycorporation().booleanValue() && this.getStampNumber().length() == 0) {
            errors.add(new ValidationError("stampNumber", "case.stampNumber.invalid"));
        }
        for (BipartisanDetails bipartisanDetails2 : this.getBipartisanDetails()) {
            element = bipartisanDetails2;
            errors.addAll(element.validate());
        }
        for (Pwr pwr : this.getPwrList()) {
            element = pwr;
            errors.addAll(element.validate());
        }
        for (LegalCaseAdvocate legalcaseAdvocate : this.getLegalCaseAdvocates()) {
            element = legalcaseAdvocate;
            errors.addAll(element.validate());
        }
        for (Judgment judgment : this.getJudgment()) {
            element = judgment;
            errors.addAll(element.validate());
        }
        this.legalcaseDeptValidation(errors);
        this.reminderValidation(errors);
        int isResGovt = 0;
        for (BipartisanDetails bipartisanDetails : this.getBipartisanDetails()) {
            if (!bipartisanDetails.getIsRespondentGovernment().booleanValue()) continue;
            ++isResGovt;
        }
        if (this.getBipartisanDetails().size() == isResGovt) {
            errors.add(new ValidationError("bipartisanDetails", "govtDept.govtDept"));
        }
        this.batchCaseValidation(errors);
        for (BatchCase batchCase : this.getBatchCaseSet()) {
            errors.addAll(batchCase.validate());
        }
        return errors;
    }

    protected void legalcaseDeptValidation(List<ValidationError> errors) {
        Boolean isPrimaryDepartment = false;
        Boolean deptPositionUniqueCheck = false;
        int i = 0;
        for (LegalCaseDepartment legalcaseDept : this.getLegalCaseDepartment()) {
            int j = 0;
            for (LegalCaseDepartment legalcaseDeptDuplicateCheck : this.getLegalCaseDepartment()) {
                if (i != j && legalcaseDept.getDepartment() != null && legalcaseDept.getPosition() != null && legalcaseDeptDuplicateCheck.getDepartment() != null && legalcaseDeptDuplicateCheck.getPosition() != null && legalcaseDept.getDepartment().getName().concat(legalcaseDept.getPosition().getName()).equals(legalcaseDeptDuplicateCheck.getDepartment().getName().concat(legalcaseDeptDuplicateCheck.getPosition().getName()))) {
                    deptPositionUniqueCheck = true;
                }
                ++j;
            }
            if (legalcaseDept.getIsPrimaryDepartment()) {
                isPrimaryDepartment = true;
            }
            errors.addAll(legalcaseDept.validate());
            ++i;
        }
        if (!isPrimaryDepartment.booleanValue()) {
            errors.add(new ValidationError("legalcaseDept.isPrimaryDept", "isPrimary.is.null"));
        }
        if (deptPositionUniqueCheck.booleanValue()) {
            errors.add(new ValidationError("legalcaseDept", "legalcaseDept.duplicate.exists"));
        }
    }

    protected void batchCaseValidation(List<ValidationError> errors) {
        Boolean duplicateCaseNumberCheck = false;
        int i = 0;
        for (BatchCase batchcase : this.getBatchCaseSet()) {
            if (StringUtils.isNotBlank((String)this.getCaseNumber()) && StringUtils.isNotBlank((String)batchcase.getCasenumber()) && this.getCaseNumber().equals(batchcase.getCasenumber())) {
                errors.add(new ValidationError("batchcaseSet", "both.casenumber.batchcasenumber"));
                break;
            }
            int j = 0;
            for (BatchCase casenumberDuplicateCheck : this.getBatchCaseSet()) {
                if (i != j && batchcase.getCasenumber() != null && batchcase.getCasenumber().equals(casenumberDuplicateCheck.getCasenumber())) {
                    duplicateCaseNumberCheck = true;
                }
                ++j;
            }
            ++i;
        }
        if (duplicateCaseNumberCheck.booleanValue()) {
            errors.add(new ValidationError("batchcaseSet", "batchcasenumber.duplicate.exists"));
        }
    }

    public Date getCaDueDate() {
        if (this.pwrList != null) {
            for (Pwr pwr : this.pwrList) {
                if (pwr.getCaDueDate() == null) continue;
                return pwr.getCaDueDate();
            }
        }
        return null;
    }

    public Date getPwrDate() {
        if (this.getPwrList() != null) {
            for (Pwr pwr : this.getPwrList()) {
                if (pwr.getPwrDueDate() == null) continue;
                return pwr.getPwrDueDate();
            }
        }
        return null;
    }

    public List<BipartisanDetails> getPetitioners() {
        ArrayList<BipartisanDetails> tempList = new ArrayList<BipartisanDetails>();
        for (BipartisanDetails temp : this.bipartisanDetails) {
            if (temp.getIsRepondent().booleanValue()) continue;
            tempList.add(temp);
        }
        HashSet tempset = new HashSet(tempList);
        this.bipartisanPetitionerDetailsList = new ArrayList<BipartisanDetails>(tempset);
        return this.bipartisanPetitionerDetailsList;
    }

    public List<BipartisanDetails> getRespondents() {
        ArrayList<BipartisanDetails> tempList = new ArrayList<BipartisanDetails>();
        for (BipartisanDetails temp : this.bipartisanDetails) {
            if (!temp.getIsRepondent().booleanValue()) continue;
            tempList.add(temp);
        }
        HashSet tempset = new HashSet(tempList);
        this.bipartisanRespondentDetailsList = new ArrayList<BipartisanDetails>(tempset);
        return this.bipartisanRespondentDetailsList;
    }

    public String getRespondantNames() {
        StringBuilder tempStr = new StringBuilder();
        for (BipartisanDetails temp : this.bipartisanDetails) {
            if (!temp.getIsRepondent().booleanValue()) continue;
            if (tempStr.length() == 0) {
                tempStr.append(temp.getName());
                continue;
            }
            tempStr.append(",\n").append(temp.getName());
        }
        return tempStr.toString();
    }

    public String getPetitionersNames() {
        StringBuilder tempStr = new StringBuilder();
        for (BipartisanDetails temp : this.bipartisanDetails) {
            if (temp.getIsRepondent().booleanValue()) continue;
            if (tempStr.length() == 0) {
                tempStr.append(temp.getName());
                continue;
            }
            tempStr.append(",\n").append(temp.getName());
        }
        return tempStr.toString();
    }

    public Judgment getJudgmentValue() {
        Judgment judgmentValue = null;
        for (Judgment j : this.getJudgment()) {
            if (j.getSapAccepted()) continue;
            judgmentValue = j;
        }
        return judgmentValue;
    }

    public String getDepartmentName() {
        for (LegalCaseDepartment ld : this.legalCaseDepartment) {
            if (ld == null || ld.getDepartment().getName() == null) continue;
            String dep = ld.getDepartment().getName();
            return dep;
        }
        return null;
    }

    public String getDepartmentName(Hashtable hs) {
        ArrayList arr = (ArrayList)hs.get(this.id);
        for (LegalCaseDepartment ld : this.legalCaseDepartment) {
            String dep;
            if (ld == null || ld.getDepartment().getName() == null || arr.contains(dep = ld.getDepartment().getName())) continue;
            return dep;
        }
        return null;
    }

    public Position getPossition() {
        for (LegalCaseDepartment ld : this.legalCaseDepartment) {
            if (ld == null || ld.getPosition() == null) continue;
            return ld.getPosition();
        }
        return null;
    }

    public Position getPossition(Hashtable hs) {
        ArrayList arr = (ArrayList)hs.get(this.id);
        for (LegalCaseDepartment ld : this.legalCaseDepartment) {
            Position p;
            if (ld == null || ld.getPosition() == null || arr.contains(p = ld.getPosition())) continue;
            return p;
        }
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getNextDate() {
        return this.nextDate;
    }

    public void setNextDate(Date nextDate) {
        this.nextDate = nextDate;
    }

    public CourtMaster getCourtMaster() {
        return this.courtMaster;
    }

    public void setCourtMaster(CourtMaster courtMaster) {
        this.courtMaster = courtMaster;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public void setIsSenioradvrequired(Boolean isSenioradvrequired) {
        this.isSenioradvrequired = isSenioradvrequired;
    }

    public String getCasetitle() {
        return this.caseTitle;
    }

    public void setCasetitle(String casetitle) {
        this.caseTitle = casetitle;
    }

    public String getAppealnum() {
        return this.appealNum;
    }

    public void setAppealnum(String appealnum) {
        this.appealNum = appealnum;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getCaseReceivingDate() {
        return this.caseReceivingDate;
    }

    public void setCaseReceivingDate(Date caseReceivingDate) {
        this.caseReceivingDate = caseReceivingDate;
    }

    public String getLcnumber() {
        return this.lcNumber;
    }

    public void setLcnumber(String lcnumber) {
        this.lcNumber = lcnumber;
    }

    public String getPrayer() {
        return this.prayer;
    }

    public void setPrayer(String prayer) {
        this.prayer = prayer;
    }

    public Boolean getIsSenioradvrequired() {
        return this.isSenioradvrequired;
    }

    public void setSenioradvrequired(Boolean isSenioradvrequired) {
        this.isSenioradvrequired = isSenioradvrequired;
    }

    public Long getAssigntoIdboundary() {
        return this.assigntoIdboundary;
    }

    public void setAssigntoIdboundary(Long assigntoIdboundary) {
        this.assigntoIdboundary = assigntoIdboundary;
    }

    public List<LegalCaseInterimOrder> getLegalCaseInterimOrder() {
        return this.legalCaseInterimOrder;
    }

    public void setLegalCaseInterimOrder(List<LegalCaseInterimOrder> legalCaseInterimOrder) {
        this.legalCaseInterimOrder = legalCaseInterimOrder;
    }

    public void addBipartisanDetails(BipartisanDetails bipartisanDetails) {
        this.bipartisanDetails.add(bipartisanDetails);
    }

    public void removeBipartisanDetails(BipartisanDetails bipartisanDetails) {
        this.bipartisanDetails.remove((Object)bipartisanDetails);
    }

    public List<Hearings> getHearings() {
        return this.hearings;
    }

    public void setHearings(List<Hearings> hearings) {
        this.hearings = hearings;
    }

    public String getOppPartyAdvocate() {
        return this.oppPartyAdvocate;
    }

    public void setOppPartyAdvocate(String oppPartyAdvocate) {
        this.oppPartyAdvocate = oppPartyAdvocate;
    }

    public String getRepresentedby() {
        return this.representedby;
    }

    public void setRepresentedby(String representedby) {
        this.representedby = representedby;
    }

    public LCNumberType getLcNumberType() {
        return this.lcNumberType;
    }

    public void setLcNumberType(LCNumberType lcNumberType) {
        this.lcNumberType = lcNumberType;
    }

    public List<LegalCaseDisposal> getLegalcaseDisposal() {
        return this.legalCaseDisposal;
    }

    public void setLegalcaseDisposal(List<LegalCaseDisposal> legalcaseDisposal) {
        this.legalCaseDisposal = legalcaseDisposal;
    }

    public List<BatchCase> getBatchCaseSet() {
        return this.batchCaseSet;
    }

    public void setBatchCaseSet(List<BatchCase> batchCaseSet) {
        this.batchCaseSet = batchCaseSet;
    }

    public List<BipartisanDetails> getBipartisanDetails() {
        return this.bipartisanDetails;
    }

    public void setBipartisanDetails(List<BipartisanDetails> bipartisanDetails) {
        this.bipartisanDetails = bipartisanDetails;
    }

    public Date getCasefirstappearancedate() {
        return this.casefirstappearancedate;
    }

    public void setCasefirstappearancedate(Date casefirstappearancedate) {
        this.casefirstappearancedate = casefirstappearancedate;
    }

    public Date getPreviousDate() {
        return this.previousDate;
    }

    public void setPreviousDate(Date previousDate) {
        this.previousDate = previousDate;
    }

    public String getStampNumber() {
        return this.stampNumber;
    }

    public void setStampNumber(String stampNumber) {
        this.stampNumber = stampNumber;
    }

    private void reminderValidation(List<ValidationError> errors) {
        for (LegalCaseDepartment legalcaseDept : this.getLegalCaseDepartment()) {
            for (Reminder reminder : legalcaseDept.getLegalCaseReminders()) {
                errors.addAll(reminder.validate());
            }
        }
    }

    public List<Judgment> getJudgment() {
        return this.judgment;
    }

    public void setJudgment(List<Judgment> judgment) {
        this.judgment = judgment;
    }

    public List<Pwr> getPwrList() {
        return this.pwrList;
    }

    public void setPwrList(List<Pwr> pwrs) {
        this.pwrList.clear();
        if (pwrs != null) {
            this.pwrList.addAll(pwrs);
        }
    }

    public void addPwrList(Pwr pwr) {
        this.pwrList.add(pwr);
    }

    public void removePwrList(Pwr pwr) {
        this.pwrList.remove((Object)pwr);
    }

    public List<CounterAffidavit> getCounterAffidavits() {
        return this.counterAffidavits;
    }

    public void setCounterAffidavits(List<CounterAffidavit> counterAffidavitsList) {
        this.counterAffidavits.clear();
        if (this.counterAffidavits != null) {
            this.counterAffidavits.addAll(counterAffidavitsList);
        }
    }

    public Date getCaseDate() {
        return this.caseDate;
    }

    public void setCaseDate(Date caseDate) {
        this.caseDate = caseDate;
    }

    public String getCaseTitle() {
        return this.caseTitle;
    }

    public void setCaseTitle(String caseTitle) {
        this.caseTitle = caseTitle;
    }

    public String getAppealNum() {
        return this.appealNum;
    }

    public void setAppealNum(String appealNum) {
        this.appealNum = appealNum;
    }

    public String getFunctionaryCode() {
        return this.functionaryCode;
    }

    public void setFunctionaryCode(String functionaryCode) {
        this.functionaryCode = functionaryCode;
    }

    public String getLcNumber() {
        return this.lcNumber;
    }

    public void setLcNumber(String lcNumber) {
        this.lcNumber = lcNumber;
    }

    public String getWpYear() {
        return this.wpYear;
    }

    public void setWpYear(String wpYear) {
        this.wpYear = wpYear;
    }

    public String getFinwpYear() {
        return this.finwpYear;
    }

    public void setFinwpYear(String finwpYear) {
        this.finwpYear = finwpYear;
    }

    public CaseTypeMaster getCaseTypeMaster() {
        return this.caseTypeMaster;
    }

    public void setCaseTypeMaster(CaseTypeMaster caseTypeMaster) {
        this.caseTypeMaster = caseTypeMaster;
    }

    public String getCaseNumber() {
        return this.caseNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public List<Judgment> getJudgmentsBeanList() {
        return this.judgmentsBeanList;
    }

    public void setJudgmentsBeanList(List<Judgment> judgmentsBeanList) {
        this.judgmentsBeanList = judgmentsBeanList;
    }

    public List<LegalCaseDocuments> getLegalCaseDocuments() {
        return this.legalCaseDocuments;
    }

    public void setLegalCaseDocuments(List<LegalCaseDocuments> legalCaseDocuments) {
        this.legalCaseDocuments = legalCaseDocuments;
    }

    public List<LegalCaseDisposal> getLegalCaseDisposal() {
        return this.legalCaseDisposal;
    }

    public void setLegalCaseDisposal(List<LegalCaseDisposal> legalCaseDisposal) {
        this.legalCaseDisposal = legalCaseDisposal;
    }

    public List<LegalCaseDepartment> getLegalCaseDepartment() {
        return this.legalCaseDepartment;
    }

    public void setLegalCaseDepartment(List<LegalCaseDepartment> legalCaseDepartment) {
        this.legalCaseDepartment.clear();
        if (legalCaseDepartment != null) {
            this.legalCaseDepartment.addAll(legalCaseDepartment);
        }
    }

    public void addLegalCaseDepartment(LegalCaseDepartment legalCaseDepartment) {
        this.legalCaseDepartment.add(legalCaseDepartment);
    }

    public void removeLegalCaseDepartment(LegalCaseDepartment legalCaseDepartment) {
        this.legalCaseDepartment.remove((Object)legalCaseDepartment);
    }

    public List<LegalCaseMiscDetails> getLegalCaseMiscDetails() {
        return this.legalCaseMiscDetails;
    }

    public void setLegalCaseMiscDetails(List<LegalCaseMiscDetails> legalCaseMiscDetails) {
        this.legalCaseMiscDetails = legalCaseMiscDetails;
    }

    public PetitionTypeMaster getPetitionTypeMaster() {
        return this.petitionTypeMaster;
    }

    public void setPetitionTypeMaster(PetitionTypeMaster petitionTypeMaster) {
        this.petitionTypeMaster = petitionTypeMaster;
    }

    public List<BipartisanDetails> getBipartisanRespondentDetailsList() {
        return this.bipartisanRespondentDetailsList;
    }

    public void setBipartisanRespondentDetailsList(List<BipartisanDetails> bipartisanRespondentDetailsList) {
        this.bipartisanRespondentDetailsList = bipartisanRespondentDetailsList;
    }

    public List<BipartisanDetails> getBipartisanPetitionerDetailsList() {
        return this.bipartisanPetitionerDetailsList;
    }

    public void setBipartisanPetitionerDetailsList(List<BipartisanDetails> bipartisanPetitionerDetailsList) {
        this.bipartisanPetitionerDetailsList = bipartisanPetitionerDetailsList;
    }

    public String getOfficerIncharge() {
        return this.officerIncharge;
    }

    public void setOfficerIncharge(String officerIncharge) {
        this.officerIncharge = officerIncharge;
    }

    public Date getNoticeDate() {
        return this.noticeDate;
    }

    public void setNoticeDate(Date noticeDate) {
        this.noticeDate = noticeDate;
    }

    public Boolean getIsfiledbycorporation() {
        return this.isfiledbycorporation;
    }

    public void setIsfiledbycorporation(Boolean isfiledbycorporation) {
        this.isfiledbycorporation = isfiledbycorporation;
    }

    public List<LegalCaseAdvocate> getLegalCaseAdvocates() {
        return this.legalCaseAdvocates;
    }

    public void setLegalCaseAdvocates(List<LegalCaseAdvocate> legalCaseAdvocates) {
        this.legalCaseAdvocates = legalCaseAdvocates;
    }
}

