/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.service.AdvocateMasterService;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.CounterAffidavit;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseAdvocate;
import org.egov.lcms.transactions.entity.LegalCaseDocuments;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.lcms.transactions.entity.PwrDocuments;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.transactions.repository.PwrDocumentsRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LegalCaseService {
    private final LegalCaseRepository legalCaseRepository;
    @Autowired
    private PwrDocumentsRepository pwrDocumentsRepository;
    @Autowired
    private AdvocateMasterService advocateMasterService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @Autowired
    public LegalCaseService(LegalCaseRepository legalCaseRepository) {
        this.legalCaseRepository = legalCaseRepository;
    }

    public LegalCase findById(Long Id2) {
        return (LegalCase)((Object)this.legalCaseRepository.findOne(Id2));
    }

    public LegalCase findByLcNumber(String lcnumber) {
        return this.legalCaseRepository.findByLcNumber(lcnumber);
    }

    public LegalCase getLegalCaseByCaseNumber(String caseNumber) {
        return this.legalCaseRepository.findByCaseNumber(caseNumber);
    }

    @Transactional
    public LegalCase persist(LegalCase legalcase) {
        legalcase.setCaseNumber(legalcase.getCaseNumber() + (legalcase.getWpYear() != null ? "/" + legalcase.getWpYear() : ""));
        legalcase.setStatus(this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "LCCREATED"));
        List<LegalCaseDocuments> legalDoc = this.legalCaseUtil.getLegalCaseDocumentList(legalcase);
        legalcase = this.prepareChildEntities(legalcase);
        this.processAndStoreApplicationDocuments(legalcase, legalDoc);
        this.updateNextDate(legalcase, legalcase.getPwrList());
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    @Transactional
    public LegalCase update(LegalCase legalcase) {
        this.updateLegalCaseDeptAndPwr(legalcase, legalcase.getPwrList());
        this.processAndStorePwrDocuments(legalcase);
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    @Transactional
    public void updateLegalCaseDeptAndPwr(LegalCase legalcase, List<Pwr> pwrList) {
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>(0);
        ArrayList<CounterAffidavit> caListtemp = new ArrayList<CounterAffidavit>(0);
        for (Pwr legalpwr : pwrList) {
            legalpwr.setLegalCase(legalcase);
            legalpwr.setCaFilingdate(new Date());
            pwrListtemp.add(legalpwr);
        }
        legalcase.getPwrList().clear();
        legalcase.setPwrList(pwrListtemp);
        for (CounterAffidavit counterAffidavit : legalcase.getCounterAffidavits()) {
            counterAffidavit.setLegalCase(legalcase);
            caListtemp.add(counterAffidavit);
        }
        legalcase.getCounterAffidavits().clear();
        legalcase.setCounterAffidavits(caListtemp);
    }

    public List<LegalCaseDocuments> getLegalCaseDocList(LegalCase legalCase) {
        return legalCase.getLegalCaseDocuments();
    }

    public List<PwrDocuments> getPwrDocList(LegalCase legalCase) {
        return legalCase.getPwrList().get(0).getPwrDocuments();
    }

    public LegalCase prepareChildEntities(LegalCase legalcase) {
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>(0);
        int serialNumberPetitioner = 1;
        int serialNumberRespondent = 1;
        if (legalcase != null) {
            if (legalcase.getBipartisanPetitionerDetailsList() != null || legalcase.getBipartisanRespondentDetailsList() != null) {
                legalcase.getBipartisanDetails().clear();
                this.legalCaseRepository.flush();
            }
            for (BipartisanDetails petitioner : legalcase.getBipartisanPetitionerDetailsList()) {
                if (petitioner.getName() != null && !petitioner.getName().trim().isEmpty()) {
                    petitioner.setSerialNumber(petitioner.getSerialNumber() != null ? petitioner.getSerialNumber() : (long)serialNumberPetitioner);
                    petitioner.setIsRepondent(Boolean.FALSE);
                    if (petitioner.getIsRespondentGovernment() == null) {
                        petitioner.setIsRespondentGovernment(Boolean.FALSE);
                    }
                    petitioner.setLegalCase(legalcase);
                    legalcase.getBipartisanDetails().add(petitioner);
                }
                ++serialNumberPetitioner;
            }
            for (BipartisanDetails respondent : legalcase.getBipartisanRespondentDetailsList()) {
                if (respondent.getName() != null && !respondent.getName().trim().isEmpty()) {
                    respondent.setSerialNumber(respondent.getSerialNumber() != null ? respondent.getSerialNumber() : (long)serialNumberRespondent);
                    respondent.setLegalCase(legalcase);
                    if (respondent.getIsRespondentGovernment() == null) {
                        respondent.setIsRespondentGovernment(Boolean.FALSE);
                    }
                    respondent.setIsRepondent(Boolean.TRUE);
                    legalcase.getBipartisanDetails().add(respondent);
                }
                ++serialNumberRespondent;
            }
        }
        if (!legalcase.getPwrList().isEmpty()) {
            for (Pwr legalpwr : legalcase.getPwrList()) {
                legalpwr.setLegalCase(legalcase);
                legalpwr.setCaFilingdate(new Date());
                pwrListtemp.add(legalpwr);
            }
            legalcase.getPwrList().clear();
            legalcase.setPwrList(pwrListtemp);
        }
        return legalcase;
    }

    @Transactional
    public LegalCase saveStandingCouncilEntity(LegalCaseAdvocate legalCaseAdvocate) {
        LegalCaseAdvocate legalCaseAdvocatetemp = null;
        AdvocateMaster seniorLegalMaster = null;
        AdvocateMaster advocateName = this.advocateMasterService.findByName(legalCaseAdvocate.getAdvocateMaster().getName());
        if (legalCaseAdvocate.getSeniorAdvocate().getName() != null) {
            seniorLegalMaster = this.advocateMasterService.findByName(legalCaseAdvocate.getSeniorAdvocate().getName());
        }
        if (!legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            legalCaseAdvocatetemp = legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().get(0);
            legalCaseAdvocatetemp.setAdvocateMaster(advocateName);
            legalCaseAdvocatetemp.setAssignedToDate(legalCaseAdvocate.getAssignedToDate());
            legalCaseAdvocatetemp.setVakalatDate(legalCaseAdvocate.getVakalatDate());
            legalCaseAdvocatetemp.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocatetemp.setIsActive(Boolean.TRUE);
            legalCaseAdvocatetemp.setChangeAdvocate(legalCaseAdvocate.getChangeAdvocate());
            legalCaseAdvocatetemp.setChangeSeniorAdvocate(legalCaseAdvocate.getChangeSeniorAdvocate());
            legalCaseAdvocatetemp.setSeniorAdvocate(seniorLegalMaster);
            legalCaseAdvocatetemp.setAssignedToDateForSenior(legalCaseAdvocate.getAssignedToDateForSenior());
            legalCaseAdvocatetemp.setOrderDate(legalCaseAdvocate.getOrderDate());
            legalCaseAdvocatetemp.setOrderNumber(legalCaseAdvocate.getOrderNumber());
            legalCaseAdvocatetemp.setOrderDateJunior(legalCaseAdvocate.getOrderDateJunior());
            legalCaseAdvocatetemp.setOrderNumberJunior(legalCaseAdvocate.getOrderNumberJunior());
            legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().add(legalCaseAdvocatetemp);
        } else {
            legalCaseAdvocate.setAdvocateMaster(advocateName);
            legalCaseAdvocate.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocate.setSeniorAdvocate(seniorLegalMaster);
            legalCaseAdvocate.setIsActive(Boolean.TRUE);
            legalCaseAdvocate.getLegalCase().getLegalCaseAdvocates().add(legalCaseAdvocate);
        }
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalCaseAdvocate.getLegalCase()));
    }

    public void processAndStoreApplicationDocuments(LegalCase legalcase, List<LegalCaseDocuments> legalDoc) {
        if (legalcase.getId() == null) {
            if (!legalcase.getLegalCaseDocuments().isEmpty()) {
                for (LegalCaseDocuments applicationDocument : legalcase.getLegalCaseDocuments()) {
                    applicationDocument.setLegalCase(legalcase);
                    applicationDocument.setDocumentName("LegalCase");
                    applicationDocument.setSupportDocs(this.legalCaseUtil.addToFileStore(applicationDocument.getFiles()));
                }
            }
        } else {
            ArrayList<LegalCaseDocuments> tempLegalCaseDoc = new ArrayList<LegalCaseDocuments>(legalcase.getLegalCaseDocuments());
            for (LegalCaseDocuments applicationDocument : tempLegalCaseDoc) {
                if (applicationDocument.getFiles() == null) continue;
                applicationDocument.setLegalCase(legalcase);
                applicationDocument.setDocumentName("LegalCase");
                applicationDocument.getSupportDocs().addAll(this.legalCaseUtil.addToFileStore(applicationDocument.getFiles()));
                legalcase.getLegalCaseDocuments().add(applicationDocument);
            }
            legalcase.getLegalCaseDocuments().addAll(legalDoc);
        }
    }

    @Transactional
    public void processAndStorePwrDocuments(LegalCase legalcase) {
        ArrayList<PwrDocuments> pwrDocList = new ArrayList<PwrDocuments>();
        if (!legalcase.getPwrList().get(0).getPwrDocuments().isEmpty()) {
            for (PwrDocuments pwr : legalcase.getPwrList().get(0).getPwrDocuments()) {
                if (pwr == null || pwr.getId() != null) continue;
                pwr.setPwr(legalcase.getPwrList().get(0));
                pwr.setDocumentName("Pwr");
                pwr.setSupportDocs(this.legalCaseUtil.addToFileStore(pwr.getFiles()));
                pwrDocList.add(pwr);
                this.pwrDocumentsRepository.save((Object)pwr);
            }
        }
    }

    @Transactional
    public LegalCase save(LegalCase legalcase) {
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    public void updateNextDate(LegalCase legalCase, List<Pwr> pwr) {
        if (pwr.get(0).getCaFilingdate() != null) {
            legalCase.setNextDate(pwr.get(0).getCaFilingdate());
        } else if (pwr.get(0).getCaDueDate() != null) {
            legalCase.setNextDate(pwr.get(0).getCaDueDate());
        } else if (pwr.get(0).getPwrDueDate() != null) {
            legalCase.setNextDate(pwr.get(0).getPwrDueDate());
        } else {
            legalCase.setNextDate(legalCase.getCaseDate());
        }
    }
}

