/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.egov.lcms.reports.entity.GenericSubReportResult;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GenericSubReportService {
    @Autowired
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<GenericSubReportResult> getGenericSubReport(GenericSubReportResult genericSubReportResult) {
        StringBuilder queryStr = new StringBuilder();
        if (genericSubReportResult.getAggregatedBy().equals("Court Name")) {
            this.getAggregateQueryByCourtName(genericSubReportResult, queryStr);
        }
        if (genericSubReportResult.getAggregatedBy().equals("Court Type")) {
            this.getAggregateQueryByCourtType(genericSubReportResult, queryStr);
        }
        if (genericSubReportResult.getAggregatedBy().equals("Petition Type")) {
            this.getAggregateQueryByPetitionType(genericSubReportResult, queryStr);
        }
        if (genericSubReportResult.getAggregatedBy().equals("Case Status")) {
            this.getAggregateQueryByCaseStatus(genericSubReportResult, queryStr);
        }
        if (genericSubReportResult.getAggregatedBy().equals("In charge officer")) {
            this.getAggregateQueryByOfficerIncharge(genericSubReportResult, queryStr);
        }
        if (genericSubReportResult.getAggregatedBy().equals("Judgement outcome")) {
            this.getAggregateQueryByJudgementOutcome(genericSubReportResult, queryStr);
        }
        Query queryResult = this.getCurrentSession().createQuery(queryStr.toString());
        queryResult = this.setParameterToQuery(genericSubReportResult, queryResult);
        List genericSubReportResultList = queryResult.list();
        return genericSubReportResultList;
    }

    private Query setParameterToQuery(GenericSubReportResult genericSubReportResultObj, Query queryResult) {
        if (genericSubReportResultObj.getAggregatedBy().equals("Case Status")) {
            queryResult.setString("moduleType", "Legal Case");
        }
        if (genericSubReportResultObj.getFromDate() != null) {
            queryResult.setDate("fromDate", genericSubReportResultObj.getFromDate());
        }
        if (genericSubReportResultObj.getToDate() != null) {
            queryResult.setDate("toDate", genericSubReportResultObj.getToDate());
        }
        if (genericSubReportResultObj.getCourtName() != null) {
            queryResult.setInteger("courtName", genericSubReportResultObj.getCourtName().intValue());
        }
        if (genericSubReportResultObj.getCourtType() != null) {
            queryResult.setString("courtType", genericSubReportResultObj.getCourtType());
        }
        if (genericSubReportResultObj.getPetitionTypeId() != null) {
            queryResult.setInteger("petitionType", genericSubReportResultObj.getPetitionTypeId().intValue());
        }
        if (genericSubReportResultObj.getStatusId() != null) {
            queryResult.setInteger("caseStatus", genericSubReportResultObj.getStatusId().intValue());
        }
        if (genericSubReportResultObj.getOfficerIncharge() != null) {
            queryResult.setString("officerIncharge", genericSubReportResultObj.getOfficerIncharge());
        }
        if (genericSubReportResultObj.getJudgmentType() != null) {
            queryResult.setString("judgmentType", genericSubReportResultObj.getJudgmentType());
        }
        if (genericSubReportResultObj.getCaseCategory() != null) {
            queryResult.setInteger("casetype", genericSubReportResultObj.getCaseCategory().intValue());
        }
        if (StringUtils.isNotBlank((String)genericSubReportResultObj.getStandingCounsel())) {
            queryResult.setString("standingCouncil", genericSubReportResultObj.getStandingCounsel());
        }
        if (genericSubReportResultObj.getOfficerIncharge() != null) {
            queryResult.setString("officerIncharge", genericSubReportResultObj.getOfficerIncharge());
        }
        queryResult.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(GenericSubReportResult.class));
        return queryResult;
    }

    private void getAppendQuery(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        if (genericSubReportResult.getFromDate() != null) {
            queryStr.append(" legalcase.caseDate >=:fromDate  and");
        }
        if (genericSubReportResult.getToDate() != null) {
            queryStr.append(" legalcase.caseReceivingDate <=:toDate ");
        }
        if (genericSubReportResult.getCourtName() != null) {
            queryStr.append(" and legalcase.courtMaster =:courtName ");
        }
        if (genericSubReportResult.getCaseCategory() != null) {
            queryStr.append(" and legalcase.caseTypeMaster =:casetype ");
        }
        if (StringUtils.isNotBlank((String)genericSubReportResult.getStandingCounsel())) {
            queryStr.append(" and legalcase.oppPartyAdvocate like :standingCouncil ");
        }
        if (genericSubReportResult.getOfficerIncharge() != null) {
            queryStr.append(" and legalcase.officerIncharge like :officerIncharge ");
        }
        if (genericSubReportResult.getStatusId() != null) {
            queryStr.append(" and egwStatus.id =:caseStatus ");
        }
        if (genericSubReportResult.getCourtType() != null) {
            queryStr.append(" and courtmaster.courtType.courtType like :courtType ");
        }
        if (genericSubReportResult.getJudgmentType() != null) {
            queryStr.append(" and judgment.judgmentType.name like :judgmentType ");
        }
        if (genericSubReportResult.getPetitionType() != null) {
            queryStr.append(" and legalcase.petitionTypeMaster =:petitionType ");
        }
    }

    private void getAggregateQueryByCourtName(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as noOfCase,courtmaster.name  as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,CourtMaster courtmaster where legalcase.courtMaster.id=courtmaster.id and ");
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by courtmaster.name");
        queryStr.append(" order by courtmaster.name");
    }

    private void getAggregateQueryByPetitionType(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as noOfCase,petmaster.petitionType as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,PetitionTypeMaster petmaster where legalcase.petitionTypeMaster.id=petmaster.id and ");
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by petmaster.petitionType");
        queryStr.append(" order by petmaster.petitionType");
    }

    private void getAggregateQueryByCourtType(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as noOfCase,courtmaster.courtType.courtType  as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,CourtMaster courtmaster where legalcase.courtMaster.id=courtmaster.id and ");
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by courtmaster.courtType.courtType");
        queryStr.append(" order by courtmaster.courtType.courtType");
    }

    private void getAggregateQueryByCaseStatus(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as noOfCase,egwStatus.description  as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,EgwStatus egwStatus where legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType and ");
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by egwStatus.description");
        queryStr.append(" order by egwStatus.description");
    }

    private void getAggregateQueryByOfficerIncharge(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as noOfCase,legalcase.officerIncharge as aggregatedBy ");
        queryStr.append("from LegalCase legalcase where ");
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by legalcase.officerIncharge");
        queryStr.append(" order by legalcase.officerIncharge");
    }

    private void getAggregateQueryByJudgementOutcome(GenericSubReportResult genericSubReportResult, StringBuilder queryStr) {
        queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as noOfCase,judgment.judgmentType.name  as aggregatedBy ");
        queryStr.append("from LegalCase legalcase,Judgment judgment  where legalcase.id = judgment.legalCase and ");
        this.getAppendQuery(genericSubReportResult, queryStr);
        queryStr.append("group by judgment.judgmentType.name");
        queryStr.append(" order by judgment.judgmentType.name");
    }
}

