/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.lcms.reports.entity.DailyBoardReportResults;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DailyBoardReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<DailyBoardReportResults> getDailyBoardReports(DailyBoardReportResults dailyBoardReportResults) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct legalObj  as  legalCase ,courtmaster.name  as  courtName ,petmaster.petitionType as petitionType,");
        queryStr.append(" egwStatus.description  as  caseStatus ");
        queryStr.append(" from LegalCase legalObj,CourtMaster courtmaster,CaseTypeMaster casetypemaster,");
        queryStr.append(" PetitionTypeMaster petmaster,EgwStatus egwStatus");
        queryStr.append(" where legalObj.courtMaster.id=courtmaster.id and ");
        queryStr.append(" legalObj.caseTypeMaster.id=casetypemaster.id and legalObj.petitionTypeMaster.id=petmaster.id and ");
        queryStr.append(" legalObj.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
        this.getAppendQuery(dailyBoardReportResults, queryStr);
        Query queryResult = this.getCurrentSession().createQuery(queryStr.toString());
        queryResult = this.setParameterToQuery(dailyBoardReportResults, queryResult);
        List dailyBoardReportList = queryResult.list();
        return dailyBoardReportList;
    }

    private Query setParameterToQuery(DailyBoardReportResults dailyBoardReportObj, Query queryResult) {
        queryResult.setString("moduleType", "Legal Case");
        if (StringUtils.isNotBlank((String)dailyBoardReportObj.getCaseNumber())) {
            queryResult.setString("caseNumber", dailyBoardReportObj.getCaseNumber() + "%");
        }
        if (dailyBoardReportObj.getCourtId() != null) {
            queryResult.setInteger("court", dailyBoardReportObj.getCourtId().intValue());
        }
        if (StringUtils.isNotBlank((String)dailyBoardReportObj.getOfficerIncharge())) {
            queryResult.setString("officerIncharge", dailyBoardReportObj.getOfficerIncharge());
        }
        if (dailyBoardReportObj.getCasecategory() != null) {
            queryResult.setInteger("casetype", dailyBoardReportObj.getCasecategory().intValue());
        }
        if (StringUtils.isNotBlank((String)dailyBoardReportObj.getStandingCouncil())) {
            queryResult.setString("standingCouncil", dailyBoardReportObj.getStandingCouncil() + "%");
        }
        if (dailyBoardReportObj.getStatusId() != null) {
            queryResult.setInteger("status", dailyBoardReportObj.getStatusId().intValue());
        }
        if (dailyBoardReportObj.getNextDate() != null) {
            queryResult.setString("nextDate", DateUtils.getDefaultFormattedDate((Date)dailyBoardReportObj.getNextDate()));
        }
        if (dailyBoardReportObj.getFromDate() != null) {
            queryResult.setDate("fromdate", dailyBoardReportObj.getFromDate());
        }
        if (dailyBoardReportObj.getToDate() != null) {
            queryResult.setDate("toDate", dailyBoardReportObj.getToDate());
        }
        if (dailyBoardReportObj.getPetitionTypeId() != null) {
            queryResult.setInteger("petiontionType", dailyBoardReportObj.getPetitionTypeId().intValue());
        }
        queryResult.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DailyBoardReportResults.class));
        return queryResult;
    }

    private void getAppendQuery(DailyBoardReportResults dailyBoardReportObj, StringBuilder queryStr) {
        if (StringUtils.isNotBlank((String)dailyBoardReportObj.getCaseNumber())) {
            queryStr.append(" and legalObj.caseNumber like :caseNumber ");
        }
        if (dailyBoardReportObj.getCourtId() != null) {
            queryStr.append(" and courtmaster.id =:court ");
        }
        if (dailyBoardReportObj.getCasecategory() != null) {
            queryStr.append(" and casetypemaster.id =:casetype");
        }
        if (StringUtils.isNotBlank((String)dailyBoardReportObj.getStandingCouncil())) {
            queryStr.append(" and legalObj.oppPartyAdvocate like :standingCouncil ");
        }
        if (dailyBoardReportObj.getStatusId() != null) {
            queryStr.append(" and egwStatus.id =:status ");
        }
        if (dailyBoardReportObj.getFromDate() != null) {
            queryStr.append(" and legalObj.caseDate >=:fromdate ");
        }
        if (dailyBoardReportObj.getToDate() != null) {
            queryStr.append(" and legalObj.caseDate <=:toDate ");
        }
        if (dailyBoardReportObj.getPetitionTypeId() != null) {
            queryStr.append(" and petmaster.id =:petiontionType ");
        }
        if (dailyBoardReportObj.getNextDate() != null) {
            queryStr.append(" and legalObj.nextDate=:DateUtils.getDefaultFormattedDate(nextDate)");
        }
        if (StringUtils.isNotBlank((String)dailyBoardReportObj.getOfficerIncharge())) {
            queryStr.append(" and legalObj.officerIncharge =:officerIncharge ");
        }
    }
}

