/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_VACATESTAY_PETITION")
@SequenceGenerator(name="SEQ_EGLC_VACATESTAY_PETITION", sequenceName="SEQ_EGLC_VACATESTAY_PETITION", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class VacateStay
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_VACATESTAY_PETITION = "SEQ_EGLC_VACATESTAY_PETITION";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_VACATESTAY_PETITION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="lcinterimorder", nullable=false)
    @Audited
    private LegalCaseInterimOrder legalCaseInterimOrder;
    @Temporal(value=TemporalType.DATE)
    @Column(name="receivedfromstandingcounsel")
    @Audited
    private Date vsReceivedFromStandingCounsel;
    @Temporal(value=TemporalType.DATE)
    @Column(name="sendtostandingcounsel")
    @Audited
    private Date vsSendToStandingCounsel;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy")
    @Column(name="petitionfiledon")
    @Audited
    private Date vsPetitionFiledOn;
    @Length(max=1024)
    @Audited
    private String remarks;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LegalCaseInterimOrder getLegalCaseInterimOrder() {
        return this.legalCaseInterimOrder;
    }

    public void setLegalCaseInterimOrder(LegalCaseInterimOrder legalCaseInterimOrder) {
        this.legalCaseInterimOrder = legalCaseInterimOrder;
    }

    public Date getVsReceivedFromStandingCounsel() {
        return this.vsReceivedFromStandingCounsel;
    }

    public void setVsReceivedFromStandingCounsel(Date vsReceivedFromStandingCounsel) {
        this.vsReceivedFromStandingCounsel = vsReceivedFromStandingCounsel;
    }

    public Date getVsSendToStandingCounsel() {
        return this.vsSendToStandingCounsel;
    }

    public void setVsSendToStandingCounsel(Date vsSendToStandingCounsel) {
        this.vsSendToStandingCounsel = vsSendToStandingCounsel;
    }

    public Date getVsPetitionFiledOn() {
        return this.vsPetitionFiledOn;
    }

    public void setVsPetitionFiledOn(Date vsPetitionFiledOn) {
        this.vsPetitionFiledOn = vsPetitionFiledOn;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (!DateUtils.compareDates((Date)this.getVsReceivedFromStandingCounsel(), (Date)this.getLegalCaseInterimOrder().getIoDate())) {
            errors.add(new ValidationError("iodate", "iodate.greaterThan.vsReceivedFromStandingCounsel"));
        }
        if (!DateUtils.compareDates((Date)this.getVsPetitionFiledOn(), (Date)this.getLegalCaseInterimOrder().getIoDate())) {
            errors.add(new ValidationError("iodate", "iodate.greaterThan.petitionFiledOn"));
        }
        if (!DateUtils.compareDates((Date)this.getVsSendToStandingCounsel(), (Date)this.getLegalCaseInterimOrder().getIoDate())) {
            errors.add(new ValidationError("iodate", "iodate.greaterThan.vsSendToStandingCounsel"));
        }
        if (!DateUtils.compareDates((Date)this.getVsReceivedFromStandingCounsel(), (Date)this.getVsSendToStandingCounsel())) {
            errors.add(new ValidationError("vsReceivedFromStandingCounsel", "vsReceivedFromStandingCounsel.greaterThan.vsSendToStandingCounsel"));
        }
        if (!DateUtils.compareDates((Date)this.getVsSendToStandingCounsel(), (Date)this.getVsPetitionFiledOn())) {
            errors.add(new ValidationError("petitionFiledOn", "vsSendToStandingCounsel.greaterThan.petitionFiledOn"));
        }
        return errors;
    }
}

