/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.PwrDocuments;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="EGLC_PWR")
@SequenceGenerator(name="seq_eglc_pwr", sequenceName="seq_eglc_pwr", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class Pwr
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_PWR = "seq_eglc_pwr";
    @Id
    @GeneratedValue(generator="seq_eglc_pwr", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="legalcase", nullable=false)
    @Audited
    private LegalCase legalCase;
    @Temporal(value=TemporalType.DATE)
    @Column(name="cafilingdate")
    @Audited
    private Date caFilingdate;
    @OneToMany(mappedBy="pwr", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @NotAudited
    private List<PwrDocuments> pwrDocuments = new ArrayList<PwrDocuments>(0);
    @Temporal(value=TemporalType.DATE)
    @Column(name="caduedate")
    @Audited
    private Date caDueDate;
    @Temporal(value=TemporalType.DATE)
    @Column(name="pwrduedate")
    @Audited
    private Date pwrDueDate;
    @Temporal(value=TemporalType.DATE)
    @Column(name="pwrapprovaldate")
    @Audited
    private Date pwrApprovalDate;

    public Date getCaFilingdate() {
        return this.caFilingdate;
    }

    public void setCaFilingdate(Date caFilingdate) {
        this.caFilingdate = caFilingdate;
    }

    public Date getPwrApprovalDate() {
        return this.pwrApprovalDate;
    }

    public void setPwrApprovalDate(Date pwrApprovalDate) {
        this.pwrApprovalDate = pwrApprovalDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCaDueDate() {
        return this.caDueDate;
    }

    public void setCaDueDate(Date caDueDate) {
        this.caDueDate = caDueDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (!DateUtils.compareDates((Date)this.getCaDueDate(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("caDueDate", "caDueDate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getCaFilingdate(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("caFilingDate", "caFilingDate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getPwrDueDate(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("pwrDueDate", "pwrDueDate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getCaDueDate(), (Date)this.getPwrDueDate())) {
            errors.add(new ValidationError("caDueDate", "caDueDate.greaterThan.pwrDueDate"));
        }
        return errors;
    }

    public Date getPwrDueDate() {
        return this.pwrDueDate;
    }

    public void setPwrDueDate(Date pwrDueDate) {
        this.pwrDueDate = pwrDueDate;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public List<PwrDocuments> getPwrDocuments() {
        return this.pwrDocuments;
    }

    public void setPwrDocuments(List<PwrDocuments> pwrDocuments) {
        this.pwrDocuments = pwrDocuments;
    }
}

