/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.entity.CaseStage;
import org.egov.lcms.transactions.entity.LegalCase;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_LEGALCASE_ADVOCATE")
@SequenceGenerator(name="SEQ_EGLC_LEGALCASE_ADVOCATE", sequenceName="SEQ_EGLC_LEGALCASE_ADVOCATE", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class LegalCaseAdvocate
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_LEGALCASE_ADVOCATE = "SEQ_EGLC_LEGALCASE_ADVOCATE";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LEGALCASE_ADVOCATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="legalcase", nullable=false)
    @Audited
    private LegalCase legalCase;
    @ManyToOne
    @JoinColumn(name="advocatemaster")
    @Audited
    private AdvocateMaster advocateMaster;
    @Temporal(value=TemporalType.DATE)
    @Column(name="assignedtodate")
    @Audited
    private Date assignedToDate;
    @Temporal(value=TemporalType.DATE)
    @Column(name="seniorassignedtodate")
    @Audited
    private Date assignedToDateForSenior;
    @Temporal(value=TemporalType.DATE)
    @Column(name="vakalatdate")
    @Audited
    private Date vakalatDate;
    @Audited
    private Boolean isActive;
    @Length(max=32)
    @Audited
    @Column(name="ordernumber")
    private String orderNumber;
    @Temporal(value=TemporalType.DATE)
    @Audited
    @Column(name="orderdate")
    private Date orderDate;
    @ManyToOne
    @JoinColumn(name="senioradvocate")
    @Audited
    private AdvocateMaster seniorAdvocate;
    @Length(max=32)
    @JoinColumn(name="ordernumberjunior")
    @Audited
    private String orderNumberJunior;
    @Temporal(value=TemporalType.DATE)
    @Column(name="orderdatejunior")
    @Audited
    private Date orderDateJunior;
    @ManyToOne
    @JoinColumn(name="JUNIORSTAGE")
    @Audited
    private CaseStage juniorStage;
    @ManyToOne
    @JoinColumn(name="SENIORSTAGE")
    @Audited
    private CaseStage seniorStage;
    @Length(max=256)
    @Audited
    @Column(name="reassignmentreasonjunior")
    private String reassignmentReasonJunior;
    @Length(max=256)
    @Audited
    @Column(name="reassignmentreasonsenior")
    private String reassignmentReasonSenior;
    @Audited
    private Boolean changeAdvocate = Boolean.FALSE;
    @Audited
    private Boolean changeSeniorAdvocate = Boolean.FALSE;
    @Transient
    @Audited
    private Boolean isSeniorAdvocate = Boolean.FALSE;

    public Boolean getChangeAdvocate() {
        return this.changeAdvocate;
    }

    public void setChangeAdvocate(Boolean changeAdvocate) {
        this.changeAdvocate = changeAdvocate;
    }

    public Boolean getChangeSeniorAdvocate() {
        return this.changeSeniorAdvocate;
    }

    public void setChangeSeniorAdvocate(Boolean changeSeniorAdvocate) {
        this.changeSeniorAdvocate = changeSeniorAdvocate;
    }

    public AdvocateMaster getAdvocateMaster() {
        return this.advocateMaster;
    }

    public void setAdvocateMaster(AdvocateMaster advocateMaster) {
        this.advocateMaster = advocateMaster;
    }

    public Date getAssignedToDate() {
        return this.assignedToDate;
    }

    public void setAssignedToDate(Date assignedToDate) {
        this.assignedToDate = assignedToDate;
    }

    public Date getAssignedToDateForSenior() {
        return this.assignedToDateForSenior;
    }

    public void setAssignedToDateForSenior(Date assignedToDateForSenior) {
        this.assignedToDateForSenior = assignedToDateForSenior;
    }

    public Date getVakalatDate() {
        return this.vakalatDate;
    }

    public void setVakalatDate(Date vakalatDate) {
        this.vakalatDate = vakalatDate;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public String getOrderNumberJunior() {
        return this.orderNumberJunior;
    }

    public void setOrderNumberJunior(String orderNumberJunior) {
        this.orderNumberJunior = orderNumberJunior;
    }

    public Date getOrderDateJunior() {
        return this.orderDateJunior;
    }

    public void setOrderDateJunior(Date orderDateJunior) {
        this.orderDateJunior = orderDateJunior;
    }

    public String getReassignmentReasonJunior() {
        return this.reassignmentReasonJunior;
    }

    public void setReassignmentReasonJunior(String reassignmentReasonJunior) {
        this.reassignmentReasonJunior = reassignmentReasonJunior;
    }

    public String getReassignmentReasonSenior() {
        return this.reassignmentReasonSenior;
    }

    public void setReassignmentReasonSenior(String reassignmentReasonSenior) {
        this.reassignmentReasonSenior = reassignmentReasonSenior;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.legalCase.getIsSenioradvrequired().booleanValue()) {
            if (this.getSeniorAdvocate() == null) {
                errors.add(new ValidationError("seniorAdvocate", "legalcase.seniorAdvocate.null"));
            }
            if (StringUtils.isBlank((String)this.getOrderNumber())) {
                errors.add(new ValidationError("orderNumber", "legalcase.ordernumber.null"));
            }
            if (this.getOrderNumber() == null) {
                errors.add(new ValidationError("orderDate", "legalcase.orderdate.null"));
            }
            if (!DateUtils.compareDates((Date)this.getOrderDate(), (Date)this.legalCase.getCaseReceivingDate())) {
                errors.add(new ValidationError("orderDate", "orderdate.less.casereceivingdate"));
            }
            if (!DateUtils.compareDates((Date)this.getOrderDate(), (Date)this.legalCase.getCaseDate())) {
                errors.add(new ValidationError("orderDate", "orderdate.less.casedate"));
            }
            if (!DateUtils.compareDates((Date)this.getAssignedToDateForSenior(), (Date)this.getOrderDate())) {
                errors.add(new ValidationError("assignedToDateSenior", "assignedon.less.orderdate"));
            }
        }
        if (!DateUtils.compareDates((Date)this.getAssignedToDate(), (Date)this.legalCase.getCaseReceivingDate())) {
            errors.add(new ValidationError("assignedon", "assignedon.less.casereceivingdate"));
        }
        if (!DateUtils.compareDates((Date)this.getAssignedToDate(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("assignedon", "assignedon.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getVakalatDate(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("vakalatDate", "vakalatdate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getVakalatDate(), (Date)this.legalCase.getCaseReceivingDate())) {
            errors.add(new ValidationError("vakalatDate", "vakalatdate.less.caserecdate"));
        }
        if (!DateUtils.compareDates((Date)this.getVakalatDate(), (Date)this.getAssignedToDate())) {
            errors.add(new ValidationError("vakalatDate", "vakalatdate.less.assingedon"));
        }
        return errors;
    }

    public AdvocateMaster getSeniorAdvocate() {
        return this.seniorAdvocate;
    }

    public void setSeniorAdvocate(AdvocateMaster seniorAdvocate) {
        this.seniorAdvocate = seniorAdvocate;
    }

    public CaseStage getJuniorStage() {
        return this.juniorStage;
    }

    public void setJuniorStage(CaseStage juniorStage) {
        this.juniorStage = juniorStage;
    }

    public CaseStage getSeniorStage() {
        return this.seniorStage;
    }

    public void setSeniorStage(CaseStage seniorStage) {
        this.seniorStage = seniorStage;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public Boolean getIsSeniorAdvocate() {
        return this.isSeniorAdvocate;
    }

    public void setIsSeniorAdvocate(Boolean isSeniorAdvocate) {
        this.isSeniorAdvocate = isSeniorAdvocate;
    }
}

