/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.lcms.masters.entity.JudgmentType;
import org.egov.lcms.masters.repository.JudgmentTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class JudgmentTypeService {
    private final JudgmentTypeRepository judgmentTypeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public JudgmentTypeService(JudgmentTypeRepository judgmentTypeRepository) {
        this.judgmentTypeRepository = judgmentTypeRepository;
    }

    @Transactional
    public JudgmentType persist(JudgmentType judgmentType) {
        return (JudgmentType)((Object)this.judgmentTypeRepository.save((Object)judgmentType));
    }

    public List<JudgmentType> findAll() {
        return this.judgmentTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public JudgmentType findByCode(String code) {
        return this.judgmentTypeRepository.findByCode(code);
    }

    public JudgmentType findOne(Long id) {
        return (JudgmentType)((Object)this.judgmentTypeRepository.findOne(id));
    }

    public List<JudgmentType> getJudgmentTypeList() {
        return this.judgmentTypeRepository.findAll();
    }

    public List<JudgmentType> getActiveJudgementTypes() {
        return this.judgmentTypeRepository.findByActiveTrueOrderByNameAsc();
    }

    public List<JudgmentType> search(JudgmentType judgmentType) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(JudgmentType.class);
        Root judgmentTypeObj = createQuery.from(JudgmentType.class);
        createQuery.select((Selection)judgmentTypeObj);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType JudgmentType2 = m.entity(JudgmentType.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (judgmentType.getName() == null && judgmentType.getCode() == null && judgmentType.getActive() == null) {
            resultList = this.findAll();
        } else {
            if (judgmentType.getName() != null) {
                String interimOrderType = "%" + judgmentType.getName().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)judgmentTypeObj.get("name")));
                predicates.add(cb.like(cb.lower((Expression)judgmentTypeObj.get(JudgmentType2.getDeclaredSingularAttribute("name", String.class))), interimOrderType));
            }
            if (judgmentType.getCode() != null) {
                String code = "%" + judgmentType.getCode().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)judgmentTypeObj.get("code")));
                predicates.add(cb.like(cb.lower((Expression)judgmentTypeObj.get(JudgmentType2.getDeclaredSingularAttribute("code", String.class))), code));
            }
            if (judgmentType.getActive() != null) {
                if (judgmentType.getActive().booleanValue()) {
                    predicates.add(cb.equal((Expression)judgmentTypeObj.get(JudgmentType2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)true));
                } else {
                    predicates.add(cb.equal((Expression)judgmentTypeObj.get(JudgmentType2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)false));
                }
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }
}

