/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.lcms.masters.entity.CaseTypeMaster;
import org.egov.lcms.masters.repository.CaseTypeMasterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CaseTypeMasterService {
    private final CaseTypeMasterRepository casetypeMasterRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CaseTypeMasterService(CaseTypeMasterRepository casetypeMasterRepository) {
        this.casetypeMasterRepository = casetypeMasterRepository;
    }

    @Transactional
    public CaseTypeMaster create(CaseTypeMaster casetypeMaster) {
        return (CaseTypeMaster)((Object)this.casetypeMasterRepository.save((Object)casetypeMaster));
    }

    public List<CaseTypeMaster> getCaseTypeList() {
        return this.casetypeMasterRepository.findAll();
    }

    public List<CaseTypeMaster> getActiveCaseTypeList() {
        return this.casetypeMasterRepository.findByActiveTrueOrderByCaseTypeAsc();
    }

    @Transactional
    public CaseTypeMaster update(CaseTypeMaster casetypeMaster) {
        return (CaseTypeMaster)((Object)this.casetypeMasterRepository.save((Object)casetypeMaster));
    }

    public List<CaseTypeMaster> findAll() {
        return this.casetypeMasterRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"caseType"}));
    }

    public CaseTypeMaster findByCode(String code) {
        return this.casetypeMasterRepository.findByCode(code);
    }

    public CaseTypeMaster findOne(Long id) {
        return (CaseTypeMaster)((Object)this.casetypeMasterRepository.findOne(id));
    }

    public List<CaseTypeMaster> search(CaseTypeMaster casetypeMaster) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(CaseTypeMaster.class);
        Root casetypemasters = createQuery.from(CaseTypeMaster.class);
        createQuery.select((Selection)casetypemasters);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType CasetypeMaster = m.entity(CaseTypeMaster.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (casetypeMaster.getCaseType() == null && casetypeMaster.getCode() == null && casetypeMaster.getActive() == null) {
            resultList = this.findAll();
        } else {
            if (casetypeMaster.getCode() != null) {
                String code = "%" + casetypeMaster.getCode().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)casetypemasters.get("code")));
                predicates.add(cb.like(cb.lower((Expression)casetypemasters.get(CasetypeMaster.getDeclaredSingularAttribute("code", String.class))), code));
            }
            if (casetypeMaster.getCaseType() != null) {
                String caseType = "%" + casetypeMaster.getCaseType().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)casetypemasters.get("caseType")));
                predicates.add(cb.like(cb.lower((Expression)casetypemasters.get(CasetypeMaster.getDeclaredSingularAttribute("caseType", String.class))), caseType));
            }
            if (casetypeMaster.getActive() != null) {
                if (casetypeMaster.getActive().booleanValue()) {
                    predicates.add(cb.equal((Expression)casetypemasters.get(CasetypeMaster.getDeclaredSingularAttribute("active", Boolean.class)), (Object)true));
                } else {
                    predicates.add(cb.equal((Expression)casetypemasters.get(CasetypeMaster.getDeclaredSingularAttribute("active", Boolean.class)), (Object)false));
                }
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }
}

