/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.reports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.egov.eis.entity.Employee;
import org.egov.eis.reports.entity.EmployeeAssignmentSearch;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.web.adaptor.EmployeeAssignmentSearchJson;
import org.egov.infra.utils.JsonUtils;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class AjaxEmployeeAssignmentReportController {
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AssignmentService assignmentService;

    @RequestMapping(value={"/searchemployeecodes"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getEmployeeCodes(@RequestParam String code) {
        List employees = this.employeeService.findEmployeeByCodeLike(code);
        ArrayList<String> employeeCodes = new ArrayList<String>();
        for (Employee employee : employees) {
            employeeCodes.add(employee.getCode());
        }
        return employeeCodes;
    }

    @RequestMapping(value={"/searchdesignations"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignation(@RequestParam String name) {
        return this.designationService.getDesignationsByName(name);
    }

    @RequestMapping(value={"/searchpositions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Position> getPositions(@RequestParam String name) {
        return this.assignmentService.findPositionsForEmployees(name);
    }

    @RequestMapping(value={"/employeeassignments/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchEmployeeAssignments(@ModelAttribute EmployeeAssignmentSearch employeeAssignmentSearch) {
        List employeeList = this.assignmentService.searchEmployeeAssignments(employeeAssignmentSearch);
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)employeeList, Employee.class, EmployeeAssignmentSearchJson.class) + "}";
        return result;
    }
}

