/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.employee;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/employee"})
public class EmployeeAjaxController {
    @Autowired
    private DesignationService designationService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AssignmentService assignmentService;

    @RequestMapping(value={"/ajax/designations"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getAllDesignationsByNameLike(@ModelAttribute(value="employeeBean") @RequestParam String designationName) {
        return this.designationService.getAllDesignationsByNameLike(designationName);
    }

    @RequestMapping(value={"/ajax/positions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Position> getPositionForDeptAndDesig(@ModelAttribute(value="employeeBean") @RequestParam Long deptId, @RequestParam Long desigId, @RequestParam Date fromDate, @RequestParam Date toDate, @RequestParam String positionName, @RequestParam boolean primary) {
        List posList = new ArrayList();
        posList = primary ? this.positionMasterService.getPositionsForDeptDesigAndName(deptId, desigId, fromDate, toDate, positionName) : this.positionMasterService.getPositionsForDeptDesigAndNameLike(deptId, desigId, positionName);
        return posList;
    }

    @RequestMapping(value={"/ajax/primaryPosition"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getPrimaryAssignmentsForPosition(@ModelAttribute(value="employeeBean") @RequestParam Long positionId, @RequestParam Long assignmentId, @RequestParam Date fromDate, @RequestParam Date toDate, @RequestParam String code) {
        List assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDateRange(positionId, fromDate, toDate);
        String empCode = "";
        for (Assignment assign : assignment) {
            if (assign.getId() == assignmentId || assign.getEmployee().getCode().equalsIgnoreCase(code)) continue;
            empCode = empCode.concat(assign.getEmployee().getCode()).concat(",");
        }
        return empCode;
    }
}

