/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletResponse;
import org.egov.eis.contract.EmployeeDetailsResponse;
import org.egov.eis.contract.EmployeeRequest;
import org.egov.eis.contract.EmployeeResponse;
import org.egov.eis.service.EmployeeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/employeepositions"})
public class EmployeePositionController {
    @Autowired
    private EmployeeService employeeService;

    @RequestMapping(value={"/_search"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String checkPositionExistsInWF(@RequestBody EmployeeRequest employeeRequest, @RequestParam String tenantId, HttpServletResponse response) throws Exception {
        EmployeeDetailsResponse employeeDetailsResponse = new EmployeeDetailsResponse();
        EmployeeResponse employeeResponse = new EmployeeResponse();
        if (this.employeeService.isPositionExistsInWF(employeeRequest.getPositionName(), employeeRequest.getIsPositionChanged(), employeeRequest.getFromDate(), employeeRequest.getToDate()).booleanValue()) {
            employeeResponse.setCode(employeeRequest.getCode());
            employeeResponse.setFromDate(employeeRequest.getFromDate());
            employeeResponse.setToDate(employeeRequest.getToDate());
            employeeResponse.setPositionName(employeeRequest.getPositionName());
            employeeDetailsResponse.setEmployeeResponse(employeeResponse);
        }
        response.setStatus(200);
        return this.getJSONResponse((Object)employeeDetailsResponse);
    }

    private String getJSONResponse(Object obj) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("dd-MM-yyyy"));
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }
}

