/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.actions;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name={"designations"}, location="/WEB-INF/jsp/workflow/ajaxWorkFlow-designations.jsp"), @Result(name={"approvers"}, location="/WEB-INF/jsp/workflow/ajaxWorkFlow-approvers.jsp")})
public class AjaxWorkFlowAction
extends BaseFormAction {
    private static final long serialVersionUID = -4816498948951535977L;
    private static final String WF_DESIGNATIONS = "designations";
    private static final String WF_APPROVERS = "approvers";
    private transient List<Designation> designationList;
    private transient List approverList;
    private Long designationId;
    private Long approverDepartmentId;
    private transient CustomizedWorkFlowService customizedWorkFlowService;
    private String type;
    private BigDecimal amountRule;
    private String additionalRule;
    private String currentState;
    private String pendingAction;
    private String departmentRule;
    private String designation;
    private transient List<String> roleList;
    @Autowired
    private transient AssignmentService assignmentService;
    @Autowired
    private transient DesignationService designationService;

    @Action(value="/workflow/ajaxWorkFlow-getPositionByPassingDesigId")
    public String getPositionByPassingDesigId() {
        if (this.designationId != null && this.designationId != -1L) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if (this.approverDepartmentId != null && this.approverDepartmentId != -1L) {
                paramMap.put("departmentId", this.approverDepartmentId.toString());
            }
            paramMap.put("designationId", this.designationId.toString());
            this.approverList = new ArrayList();
            List assignmentList = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(this.approverDepartmentId, this.designationId, new Date());
            for (Assignment assignment : assignmentList) {
                this.approverList.add(assignment);
            }
        }
        return WF_APPROVERS;
    }

    @Action(value="/workflow/ajaxWorkFlow-getDesignationsByObjectType")
    public String getDesignationsByObjectType() {
        if ("END".equals(this.currentState)) {
            this.currentState = "";
        }
        this.designationList = StringUtils.isNotBlank((CharSequence)this.designation) ? this.designationService.getDesignationsByNames(this.customizedWorkFlowService.getNextDesignations(this.type, this.departmentRule, this.amountRule, this.additionalRule, this.currentState, this.pendingAction, new Date(), this.designation)) : this.designationService.getDesignationsByNames(this.customizedWorkFlowService.getNextDesignations(this.type, this.departmentRule, this.amountRule, this.additionalRule, this.currentState, this.pendingAction, new Date()));
        if (this.designationList.isEmpty()) {
            this.designationList = this.persistenceService.findAllBy("from Designation", new Object[0]);
        }
        return WF_DESIGNATIONS;
    }

    public void getAjaxValidButtonsAndNextAction() throws IOException {
        StringBuilder actionString = new StringBuilder();
        WorkFlowMatrix matrix = this.getWfMatrix();
        if (StringUtils.isBlank((CharSequence)this.currentState)) {
            if (matrix != null && "END".equals(matrix.getNextAction())) {
                actionString.append("Save,Approve");
            } else {
                actionString.append("Save,Forward");
            }
            actionString.append('@');
            if (matrix != null) {
                actionString.append(matrix.getNextAction());
            } else {
                actionString.append(' ');
            }
        } else if (matrix != null) {
            actionString.append(matrix.getValidActions());
            actionString.append('@');
            actionString.append(matrix.getNextAction());
        }
        ServletActionContext.getResponse().getWriter().write(actionString.toString());
    }

    private WorkFlowMatrix getWfMatrix() {
        return this.customizedWorkFlowService.getWfMatrix(this.type, this.departmentRule, this.amountRule, this.additionalRule, this.currentState, this.pendingAction);
    }

    public List<Designation> getDesignationList() {
        return this.designationList;
    }

    public List getApproverList() {
        return this.approverList;
    }

    public void setDesignationId(Long designationId) {
        this.designationId = designationId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAmountRule(BigDecimal amountRule) {
        this.amountRule = amountRule;
    }

    public void setAdditionalRule(String additionalRule) {
        this.additionalRule = additionalRule;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public void setApproverDepartmentId(Long approverDepartmentId) {
        this.approverDepartmentId = approverDepartmentId;
    }

    public void setDepartmentRule(String departmentRule) {
        this.departmentRule = departmentRule;
    }

    public Object getModel() {
        return null;
    }

    public void setCustomizedWorkFlowService(CustomizedWorkFlowService customizedWorkFlowService) {
        this.customizedWorkFlowService = customizedWorkFlowService;
    }

    public void setPendingAction(String pendingAction) {
        this.pendingAction = pendingAction;
    }

    public List<String> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<String> roleList) {
        this.roleList = roleList;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }
}

