/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.position;

import java.util.List;
import javax.validation.Valid;
import org.egov.eis.service.DeptDesigService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/position/create"})
public class CreatePositionController {
    private DepartmentService departmentService;
    private DesignationService designationService;
    private PositionMasterService positionMasterService;
    private DeptDesigService deptDesigService;
    private static final String SUCCESS_MESSAGE = "Successfully created Position !";
    private static final String WARNING = "warning";
    private static final String POSITION_ALREADY_PRESENT = "Position name already exist. Please change position name.";

    @Autowired
    private CreatePositionController(DeptDesigService deptDesigService, DepartmentService departmentService, DesignationService designationMasterService, PositionMasterService positionMasterService) {
        this.deptDesigService = deptDesigService;
        this.departmentService = departmentService;
        this.designationService = designationMasterService;
        this.positionMasterService = positionMasterService;
    }

    @ModelAttribute(value="departments")
    public List<Department> departments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute(value="designations")
    public List<Designation> designations() {
        return this.designationService.getAllDesignationsSortByNameAsc();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String createPositionForm(@ModelAttribute Position position) {
        return "position-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String createPosition(@Valid @ModelAttribute Position position, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "position-form";
        }
        if (!this.positionMasterService.validatePosition(position)) {
            model.addAttribute(WARNING, (Object)POSITION_ALREADY_PRESENT);
            return "position-form";
        }
        if (position != null && position.getDeptDesig() != null && position.getDeptDesig().getDepartment() != null && position.getDeptDesig().getDesignation() != null) {
            DeptDesig departmentDesignation = this.deptDesigService.findByDepartmentAndDesignation(position.getDeptDesig().getDepartment().getId(), position.getDeptDesig().getDesignation().getId());
            if (departmentDesignation != null) {
                departmentDesignation.setSanctionedPosts(Integer.valueOf(departmentDesignation.getSanctionedPosts() != null ? departmentDesignation.getSanctionedPosts() + 1 : 1));
                if (position.isPostOutsourced()) {
                    departmentDesignation.setOutsourcedPosts(Integer.valueOf(departmentDesignation.getOutsourcedPosts() != null ? departmentDesignation.getOutsourcedPosts() + 1 : 1));
                }
                position.setDeptDesig(departmentDesignation);
            } else {
                position.getDeptDesig().setSanctionedPosts(Integer.valueOf(1));
                if (position.isPostOutsourced()) {
                    position.getDeptDesig().setOutsourcedPosts(Integer.valueOf(1));
                } else {
                    position.getDeptDesig().setOutsourcedPosts(Integer.valueOf(0));
                }
            }
        }
        this.positionMasterService.createPosition(position);
        model.addAttribute("mode", (Object)"saved");
        model.addAttribute(WARNING, (Object)SUCCESS_MESSAGE);
        return "position-form";
    }
}

