/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.employee;

import java.io.IOException;
import java.util.Arrays;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.service.AccountDetailKeyService;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.eis.repository.EmployeeTypeRepository;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.web.controller.masters.employee.ViewAndUpdateEmployeController;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.postgresql.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/employee"})
public class CreateEmployeeController {
    private static final Logger LOGGER = Logger.getLogger(ViewAndUpdateEmployeController.class);
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EmployeeTypeRepository employeeTypeRepository;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private AccountDetailKeyService accountDetailKeyService;

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String createForm(Model model) {
        model.addAttribute("employee", (Object)new Employee());
        this.setDropDownValues(model);
        model.addAttribute("mode", (Object)"create");
        return "employee-form";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String createEmployee(@Valid @ModelAttribute Employee employee, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam MultipartFile file, Model model) {
        Boolean codeExists = this.employeeService.validateEmployeeCode(employee);
        if (codeExists.booleanValue()) {
            errors.rejectValue("code", "Unique.employee.code");
        }
        if (!this.employeeService.primaryAssignmentExists(employee).booleanValue() && employee.isActive()) {
            errors.rejectValue("assignments", "primary.assignment");
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("mode", (Object)"create");
            return "employee-form";
        }
        try {
            employee.setSignature(file.getBytes());
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error in loading Employee Signature" + e.getMessage()), (Throwable)e);
        }
        this.employeeService.create(employee);
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("Employee");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setAccountdetailtype(accountdetailtype);
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(employee.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        this.accountDetailKeyService.createAccountDetailKey(adk);
        String image = null;
        if (null != employee.getSignature()) {
            image = Base64.encodeBytes((byte[])employee.getSignature());
        }
        model.addAttribute("image", (Object)image);
        redirectAttrs.addFlashAttribute("employee", (Object)employee);
        model.addAttribute("message", (Object)"Employee created successfully");
        return "employee-success";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("employeeStatus", Arrays.asList(EmployeeStatus.values()));
        model.addAttribute("department", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("employeeTypes", (Object)this.employeeTypeRepository.findAll());
        model.addAttribute("fundList", (Object)this.employeeService.getAllFunds());
        model.addAttribute("functionaryList", (Object)this.employeeService.getAllFunctionaries());
        model.addAttribute("functionList", (Object)this.employeeService.getAllFunctions());
        model.addAttribute("gradeList", (Object)this.employeeService.getAllGrades());
        model.addAttribute("boundaryType", (Object)this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION"));
    }
}

