/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.designation;

import javax.validation.Valid;
import org.egov.eis.service.DesignationService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/designation/update/{name}"})
public class UpdateDesignationController {
    private DesignationService designationService;

    @Autowired
    public UpdateDesignationController(DesignationService designationService) {
        this.designationService = designationService;
    }

    @ModelAttribute
    public Designation designationModel(@PathVariable String name) {
        return this.designationService.getDesignationByName(name);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String updateForm(Model model) {
        model.addAttribute("mode", (Object)"update");
        return "designation-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateDesignation(@Valid @ModelAttribute Designation designation, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("mode", (Object)"update");
            return "designation-form";
        }
        this.designationService.updateDesignation(designation);
        redirectAttrs.addFlashAttribute("designation", (Object)designation);
        model.addAttribute("message", (Object)"Designation updated successfully");
        return "success-designation";
    }
}

