/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.reports.entity.EmployeePositionResult;
import org.egov.eis.reports.entity.EmployeePositionSearch;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.adaptor.EmployeePositionReportAdaptor;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.utils.JsonUtils;
import org.egov.pims.commons.Position;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class EmployeePositionReportController {
    public static final String CONTENTTYPE_JSON = "application/json";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AssignmentService assignmentService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/employeePositionReport"})
    public String searchEmployeePositionForm(Model model) {
        this.setDropDownValues(model);
        model.addAttribute("employee", (Object)new EmployeePositionSearch());
        return "employeePositionReport-form";
    }

    @RequestMapping(value={"/empPositionList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response, EmployeePositionSearch employeeSearch, Model model) throws IOException {
        ArrayList<EmployeePositionResult> empPosResultList = new ArrayList<EmployeePositionResult>();
        List assignList = this.assignmentService.getAssignmentList(employeeSearch);
        for (Assignment assign : assignList) {
            EmployeePositionResult empPosition = new EmployeePositionResult();
            empPosition.setCode(assign.getEmployee().getCode());
            empPosition.setName(assign.getEmployee().getName());
            empPosition.setDepartment(assign.getDepartment());
            empPosition.setDesignation(assign.getDesignation());
            empPosition.setPosition(assign.getPosition());
            empPosition.setIsPrimary(Boolean.valueOf(assign.getPrimary()));
            empPosition.setFromDate(assign.getFromDate());
            empPosition.setToDate(assign.getToDate());
            empPosResultList.add(empPosition);
        }
        StringBuilder employeePositionJSONData = new StringBuilder("{\"data\":").append(JsonUtils.toJSON(empPosResultList, EmployeePositionResult.class, EmployeePositionReportAdaptor.class)).append("}");
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((CharSequence)employeePositionJSONData, (Writer)response.getWriter());
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("department", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("desigList", (Object)this.designationService.getAllDesignations());
        model.addAttribute("position", (Object)this.positionMasterService.getAllPositions());
    }

    @RequestMapping(value={"/positions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Position> getPositionByDepartmentAndDesignation(@RequestParam Long deptId, @RequestParam Long desigId) {
        if (deptId != null && desigId != null) {
            return this.positionMasterService.getPositionsByDepartmentAndDesignation(deptId, desigId);
        }
        if (deptId != null) {
            return this.positionMasterService.getPositionsByDepartment(deptId);
        }
        if (desigId != null) {
            return this.positionMasterService.getPositionsByDesignation(desigId);
        }
        return this.positionMasterService.getAllPositions();
    }
}

