/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.infra.utils.DateUtils;

public class EmployeeAssignmentSearchJson
implements JsonSerializer<Employee> {
    public JsonElement serialize(Employee employee, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        int maxTempAssignments = 0;
        if (employee != null) {
            jsonObject.addProperty("employeeCode", employee.getCode());
            jsonObject.addProperty("employeeName", employee.getName());
            int i = 0;
            for (Assignment assignment : employee.getAssignments()) {
                if (assignment.getPrimary()) {
                    jsonObject.addProperty("primaryDepartment", assignment.getDepartment().getName());
                    jsonObject.addProperty("primaryDesignation", assignment.getDesignation().getName());
                    jsonObject.addProperty("primaryPosition", assignment.getPosition().getName());
                    jsonObject.addProperty("primaryDateRange", DateUtils.getDefaultFormattedDate((Date)assignment.getFromDate()) + " - " + DateUtils.getDefaultFormattedDate((Date)assignment.getToDate()));
                    continue;
                }
                jsonObject.addProperty("temporaryDepartment_" + i, assignment.getDepartment() != null ? assignment.getDepartment().getName() : "");
                jsonObject.addProperty("temporaryDesignation_" + i, assignment.getDesignation() != null ? assignment.getDesignation().getName() : "");
                jsonObject.addProperty("temporaryPosition_" + i, assignment.getPosition() != null ? assignment.getPosition().getName() : "");
                jsonObject.addProperty("temporaryDateRange_" + i, assignment.getFromDate() != null && assignment.getToDate() != null ? DateUtils.getDefaultFormattedDate((Date)assignment.getFromDate()) + " - " + DateUtils.getDefaultFormattedDate((Date)assignment.getToDate()) : "");
                ++i;
            }
            if (employee.getAssignments().size() >= maxTempAssignments) {
                maxTempAssignments = employee.getAssignments().size();
            }
        }
        jsonObject.addProperty("tempPositions", (Number)maxTempAssignments);
        return jsonObject;
    }
}

