/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.designation;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.eis.service.DesignationService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/designation/update"})
public class SearchDesignationController {
    private DesignationService designationService;

    @Autowired
    public SearchDesignationController(DesignationService designationService) {
        this.designationService = designationService;
    }

    @ModelAttribute(value="designationList")
    public List<Designation> listDesignation() {
        return this.designationService.getAllDesignationsSortByNameAsc();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("designation", (Object)new Designation());
        return "designation-list";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String searchResult(@ModelAttribute Designation designation, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "designation-list";
        }
        return "redirect:/designation/update/" + designation.getName();
    }
}

