/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.reports;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import com.lowagie.text.DocumentException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.reports.entity.EmployeeAssignmentSearch;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.utils.EisUtils;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.utils.DateUtils;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.jfree.util.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class EmployeeAssignmentReportPDFController {
    public static final String EMPLOYEEASSIGNMENTPDF = "employeeAssignemntPdf";
    private static final int MB = 0x100000;
    private static final String REPORT_NO_DATA = "No Data";
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EisUtils eisUtils;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private PositionMasterService positionMasterService;

    @RequestMapping(value={"/reports/employeeassignments/pdf"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEmployeeAssignmentsPDF(HttpServletRequest request, @RequestParam(value="code") String code, @RequestParam(value="name") String name, @RequestParam(value="departmentId") Long departmentId, @RequestParam(value="designationId") Long designationId, @RequestParam(value="positionId") Long positionId, @RequestParam(value="contentType") String contentType, @RequestParam(value="date") Date date, HttpSession session, Model model) throws DocumentException {
        EmployeeAssignmentSearch employeeAssignmentSearch = new EmployeeAssignmentSearch();
        employeeAssignmentSearch.setEmployeeCode(code);
        employeeAssignmentSearch.setEmployeeName(name);
        employeeAssignmentSearch.setDepartment(departmentId);
        employeeAssignmentSearch.setDesignation(designationId);
        employeeAssignmentSearch.setPosition(positionId);
        employeeAssignmentSearch.setAssignmentDate(date);
        List employeeList = this.assignmentService.searchEmployeeAssignments(employeeAssignmentSearch);
        StringBuilder searchCriteria = new StringBuilder();
        searchCriteria.append("Employee Assignment Report for ");
        if (employeeAssignmentSearch.getAssignmentDate() != null) {
            searchCriteria.append("Date : ").append(DateUtils.getDefaultFormattedDate((Date)employeeAssignmentSearch.getAssignmentDate())).append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)employeeAssignmentSearch.getEmployeeName())) {
            searchCriteria.append("Employee Name : ").append(employeeAssignmentSearch.getEmployeeName()).append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)employeeAssignmentSearch.getEmployeeCode())) {
            searchCriteria.append("Employee Code : ").append(employeeAssignmentSearch.getEmployeeCode()).append(",");
        }
        if (employeeAssignmentSearch.getDepartment() != null) {
            Department department = this.departmentService.getDepartmentById(employeeAssignmentSearch.getDepartment());
            searchCriteria.append("Department : ").append(department.getName()).append(",");
        }
        if (employeeAssignmentSearch.getDesignation() != null) {
            Designation designation = this.designationService.getDesignationById(employeeAssignmentSearch.getDesignation());
            searchCriteria.append("Designation : ").append(designation.getName()).append(",");
        }
        if (employeeAssignmentSearch.getPosition() != null) {
            Position position = this.positionMasterService.getPositionById(employeeAssignmentSearch.getPosition());
            searchCriteria.append("Position : ").append(position.getName()).append(",");
        }
        String searchString = "";
        if (searchCriteria.toString().endsWith(",")) {
            searchString = searchCriteria.substring(0, searchCriteria.length() - 1);
        }
        ArrayList<EmployeeAssignmentSearch> searchResult = new ArrayList<EmployeeAssignmentSearch>();
        HashMap<String, String> tempAssignments = null;
        EmployeeAssignmentSearch empAssignmentSearch = null;
        int maxTempAssignments = 0;
        for (Employee employee : employeeList) {
            int index = 0;
            tempAssignments = new HashMap<String, String>();
            empAssignmentSearch = new EmployeeAssignmentSearch();
            empAssignmentSearch.setEmployeeCode(employee.getCode());
            empAssignmentSearch.setEmployeeName(employee.getName());
            for (Assignment assignment : employee.getAssignments()) {
                if (assignment.getPrimary()) {
                    empAssignmentSearch.setDepartmentName(assignment.getDepartment().getName());
                    empAssignmentSearch.setDesignationName(assignment.getDesignation().getName());
                    empAssignmentSearch.setPositionName(assignment.getPosition().getName());
                    empAssignmentSearch.setDateRange(DateUtils.getDefaultFormattedDate((Date)assignment.getFromDate()) + " - " + DateUtils.getDefaultFormattedDate((Date)assignment.getToDate()));
                    continue;
                }
                tempAssignments.put("department_" + String.valueOf(index), assignment.getDepartment().getName());
                tempAssignments.put("designation_" + String.valueOf(index), assignment.getDesignation().getName());
                tempAssignments.put("position_" + String.valueOf(index), assignment.getPosition().getName());
                tempAssignments.put("daterange_" + String.valueOf(index), DateUtils.getDefaultFormattedDate((Date)assignment.getFromDate()) + " - " + DateUtils.getDefaultFormattedDate((Date)assignment.getToDate()));
                ++index;
            }
            empAssignmentSearch.setTempPositionDetails(tempAssignments);
            searchResult.add(empAssignmentSearch);
            if (employee.getAssignments().size() < maxTempAssignments) continue;
            maxTempAssignments = employee.getAssignments().size();
        }
        ByteArrayOutputStream outputBytes = null;
        try {
            JasperPrint jasperPrint = this.generateEmployeeAssignmentReport(searchResult, maxTempAssignments, searchString);
            outputBytes = new ByteArrayOutputStream(0x100000);
            JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputBytes);
        }
        catch (Exception e) {
            Log.error((Object)"Error while generating employee assignment report ", (Exception)e);
        }
        ReportOutput reportOutput = new ReportOutput();
        reportOutput.setReportOutputData(outputBytes.toByteArray());
        HttpHeaders headers = new HttpHeaders();
        if (contentType.equalsIgnoreCase("pdf")) {
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=EmployeeAssignment.pdf");
        } else {
            reportOutput.setReportFormat(ReportConstants.FileFormat.XLS);
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
            headers.add("content-disposition", "inline;filename=EmployeeAssignment.xls");
        }
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private JasperPrint generateEmployeeAssignmentReport(List<EmployeeAssignmentSearch> searchResult, int maxTempAssignments, String searchString) throws ColumnBuilderException, ClassNotFoundException, JRException {
        FastReportBuilder reportBuilder = new FastReportBuilder();
        Style STYLE_BLANK = Style.createBlankStyle((String)"oddRowNoStyle");
        reportBuilder.setPrintBackgroundOnOddRows(false).setWhenNoData(REPORT_NO_DATA, null).setDefaultStyles(this.eisUtils.getTitleStyle(), this.eisUtils.getSubTitleStyle(), STYLE_BLANK, STYLE_BLANK).setDetailHeight(70).setUseFullPageWidth(true).setTitleHeight(Integer.valueOf(100)).setPageSizeAndOrientation(Page.Page_A4_Landscape()).setOddRowBackgroundStyle(STYLE_BLANK).setWhenResourceMissingShowKey();
        reportBuilder.addColumn("Employee Code", "employeeCode", String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign()).addColumn("Employee Name", "employeeName", String.class.getName(), 5, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign()).addColumn("Department", "departmentName", String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign()).addColumn("Designation", "designationName", String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign()).addColumn("Position", "positionName", String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign()).addColumn("Date Range", "dateRange", String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign());
        reportBuilder.setTitle(searchString);
        for (int i = 0; i < maxTempAssignments - 1; ++i) {
            reportBuilder.addColumn("Department", "tempPositionDetails.department_" + i, String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign());
            reportBuilder.addColumn("Designation", "tempPositionDetails.designation_" + i, String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign());
            reportBuilder.addColumn("Position", "tempPositionDetails.position_" + i, String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign());
            reportBuilder.addColumn("Date Range", "tempPositionDetails.daterange_" + i, String.class.getName(), 3, this.eisUtils.getTextStyleLeftBorder(), this.eisUtils.getHeaderStyleLeftAlign());
        }
        Style colspanStyle = new Style();
        colspanStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        reportBuilder.setColspan(2, 4, "Primary Position");
        int k = 1;
        for (int i = 6; i < reportBuilder.getColumns().size(); i += 4) {
            reportBuilder.setColspan(i, 4, "Temporary Position " + k);
            ++k;
        }
        DynamicReport dr = reportBuilder.build();
        dr.getOptions().getDefaultHeaderStyle().setBorder(Border.PEN_1_POINT());
        dr.setWhenNoDataShowColumnHeader(false);
        dr.setWhenNoDataShowTitle(false);
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(searchResult);
        return DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds);
    }
}

