/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.employee;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.EmployeeAdaptor;
import org.egov.eis.entity.EmployeeSearchDTO;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.eis.repository.EmployeeTypeRepository;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.web.utils.WebUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/employee"})
public class SearchEmployeeController {
    public static final String CONTENTTYPE_JSON = "application/json";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private EmployeeTypeRepository employeeTypeRepository;
    @Autowired
    private DesignationService designationService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @RequestMapping(value={"search"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        this.setDropDownValues(model);
        model.addAttribute("employee", (Object)new EmployeeSearchDTO());
        return "employeesearch-form";
    }

    @RequestMapping(value={"ajax/employees"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTables(HttpServletRequest request, HttpServletResponse response, EmployeeSearchDTO employee) throws IOException {
        List employees = this.employeeService.searchEmployees(employee);
        StringBuilder employeeJSONData = new StringBuilder("{\"data\":").append(WebUtils.toJSON((Collection)employees, Employee.class, EmployeeAdaptor.class)).append("}");
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((CharSequence)employeeJSONData, (Writer)response.getWriter());
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("employeeStatus", Arrays.asList(EmployeeStatus.values()));
        model.addAttribute("department", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("employeeTypes", (Object)this.employeeTypeRepository.findAll());
        model.addAttribute("fundList", (Object)this.employeeService.getAllFunds());
        model.addAttribute("functionaryList", (Object)this.employeeService.getAllFunctionaries());
        model.addAttribute("functionList", (Object)this.employeeService.getAllFunctions());
        model.addAttribute("gradeList", (Object)this.employeeService.getAllGrades());
        model.addAttribute("desigList", (Object)this.designationService.getAllDesignations());
    }
}

