/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.employee;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.service.AccountDetailKeyService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.EmployeeType;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.eis.repository.EmployeeTypeRepository;
import org.egov.eis.service.DeptDesigService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.utils.constants.EisConstants;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.postgresql.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/employeeMaster"})
public class CreateEmployeeDataEntryController {
    private static final Logger LOGGER = Logger.getLogger(CreateEmployeeDataEntryController.class);
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private EmployeeTypeRepository employeeTypeRepository;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DeptDesigService deptDesigService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AccountDetailKeyService accountDetailKeyService;

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String createForm(Model model) {
        model.addAttribute("employee", (Object)new Employee());
        this.setDropDownValues(model);
        model.addAttribute("mode", (Object)"create");
        return "employee-form-simple";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String createEmployee(@Valid @ModelAttribute Employee employee, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam MultipartFile file, @RequestParam String designationName, @RequestParam Long deptId, Model model) {
        String employeeCode = employee.getCode().replaceFirst("^0+(?!$)", "");
        List employeeList = this.employeeService.findEmployeeByCodeLike(employeeCode);
        if (employeeList.size() != 0 && !employeeList.isEmpty()) {
            for (Employee emp : employeeList) {
                String empCode = emp.getCode().replaceFirst("^0+(?!$)", "");
                if (emp.getCode().equals(employee.getCode()) || !employeeCode.equals(empCode)) continue;
                errors.rejectValue("code", "Unique.employee.code");
            }
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("mode", (Object)"create");
            return "employee-form-simple";
        }
        Department department = this.departmentService.getDepartmentById(deptId);
        Designation designation = this.designationService.getDesignationByName(designationName);
        EmployeeType empType = this.employeeTypeRepository.findByName("Permanent");
        EmployeeStatus empStatus = EmployeeStatus.EMPLOYED;
        try {
            employee.setEmployeeStatus(empStatus);
            employee.setEmployeeType(empType);
            employee.setActive(EisConstants.ISACTIVE_TRUE.booleanValue());
            employee.setSignature(file.getBytes());
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error in loading Employee Signature" + e.getMessage()), (Throwable)e);
        }
        DeptDesig departmentDesignation = this.deptDesigService.findByDepartmentAndDesignation(department.getId(), designation.getId());
        Position position = new Position();
        if (departmentDesignation != null) {
            departmentDesignation.setSanctionedPosts(Integer.valueOf(departmentDesignation.getSanctionedPosts() != null ? departmentDesignation.getSanctionedPosts() + 1 : 1));
            position.setDeptDesig(departmentDesignation);
        } else {
            departmentDesignation = new DeptDesig();
            departmentDesignation.setDepartment(department);
            departmentDesignation.setDesignation(designation);
            departmentDesignation.setSanctionedPosts(Integer.valueOf(1));
            departmentDesignation.setOutsourcedPosts(Integer.valueOf(0));
            position.setDeptDesig(departmentDesignation);
        }
        String positionName = this.positionMasterService.generatePositionByDeptDesig(department, designation);
        position.setName(positionName);
        this.positionMasterService.createPosition(position);
        Date fromDate = null;
        Date toDate = null;
        try {
            fromDate = DDMMYYYYFORMATS.parse("01/04/2015");
            toDate = DDMMYYYYFORMATS.parse("31/12/2099");
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error in getting fromDate and toDate" + e.getMessage()), (Throwable)e);
        }
        List user = new ArrayList();
        Set roles = this.designationService.getRolesByDesignation(designation.getName());
        for (Role role : roles) {
            user = this.userService.getUsersByUsernameAndRolename(employee.getUsername(), this.roleService.getRoleByName(role.getName()).getName());
            if (!fromDate.before(new Date()) || !toDate.after(new Date()) || !user.isEmpty() && null != user) continue;
            employee.addRole(this.roleService.getRoleByName(role.getName()));
        }
        ArrayList<Assignment> assignment = new ArrayList<Assignment>();
        Assignment assign = new Assignment();
        assign.setDepartment(department);
        assign.setDesignation(designation);
        assign.setEmployee(employee);
        assign.setFromDate(fromDate);
        assign.setToDate(toDate);
        assign.setPrimary(EisConstants.IS_PRIMARY_TRUE.booleanValue());
        assign.setPosition(position);
        assignment.add(assign);
        ArrayList<Jurisdiction> jurisdictions = new ArrayList<Jurisdiction>();
        Jurisdiction jurisdiction = new Jurisdiction();
        jurisdiction.setEmployee(employee);
        jurisdiction.setBoundaryType(this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName("City", "ADMINISTRATION"));
        jurisdiction.setBoundary(this.boundaryService.getBoundaryByBndryTypeNameAndHierarchyTypeName("City", "ADMINISTRATION"));
        jurisdictions.add(jurisdiction);
        employee.setAssignments(assignment);
        employee.setJurisdictions(jurisdictions);
        this.employeeService.createEmployeeData(employee);
        Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("Employee");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setAccountdetailtype(accountdetailtype);
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(employee.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        this.accountDetailKeyService.createAccountDetailKey(adk);
        String image = null;
        if (null != employee.getSignature()) {
            image = Base64.encodeBytes((byte[])employee.getSignature());
        }
        model.addAttribute("image", (Object)image);
        redirectAttrs.addFlashAttribute("employee", (Object)employee);
        model.addAttribute("message", (Object)"Employee created successfully");
        return "employee-success";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("department", (Object)this.departmentService.getAllDepartments());
    }
}

