/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.position;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.egov.eis.service.DeptDesigService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.eis.web.controller.masters.position.PositionAdaptor;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/position"})
public class SearchPositionController {
    private final DepartmentService departmentService;
    private final DesignationService designationService;
    private final DeptDesigService deptDesigService;
    private final PositionMasterService positionMasterService;
    private static final String WARNING = "warning";
    private static final String POSITION_NOT_PRESENT = "There is no position added for the selected department and designation.";

    @Autowired
    private SearchPositionController(PositionMasterService positionMasterService, DepartmentService departmentService, DesignationService designationMasterService, DeptDesigService deptDesigService) {
        this.departmentService = departmentService;
        this.designationService = designationMasterService;
        this.deptDesigService = deptDesigService;
        this.positionMasterService = positionMasterService;
    }

    @ModelAttribute
    public DeptDesig deptDesig() {
        return new DeptDesig();
    }

    @ModelAttribute(value="departments")
    public List<Department> departments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute(value="designations")
    public List<Designation> designations() {
        return this.designationService.getAllDesignationsSortByNameAsc();
    }

    @RequestMapping(value={"search"}, method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("mode", (Object)"new");
        return "position-search";
    }

    @RequestMapping(value={"position-getTotalPositionCount"}, method={RequestMethod.GET})
    @ResponseBody
    public String searchSanctionedAndOutSourcePositions(@RequestParam String departmentId, @RequestParam String designationId) {
        Long deptid = 0L;
        Long desigid = 0L;
        Integer outsourcedPost = 0;
        Integer sanctionedPost = 0;
        if (departmentId != null && !"".equals(departmentId)) {
            deptid = Long.valueOf(departmentId);
        }
        if (designationId != null && !"".equals(designationId)) {
            desigid = Long.valueOf(designationId);
        }
        outsourcedPost = this.positionMasterService.getTotalOutSourcedPosts(deptid, desigid);
        sanctionedPost = this.positionMasterService.getTotalSanctionedPosts(deptid, desigid);
        return outsourcedPost + "/" + sanctionedPost;
    }

    @RequestMapping(value={"position-update"}, method={RequestMethod.GET})
    @ResponseBody
    public String changePosition(@RequestParam String desigName, @RequestParam String positionName, @RequestParam String deptName, @RequestParam String isoutsourced, @RequestParam String positionId) {
        if (positionId != null) {
            List positionList;
            Position positionObj = this.positionMasterService.getPositionById(Long.valueOf(positionId));
            if (positionObj != null && !positionObj.getName().equalsIgnoreCase(positionName) && (positionList = this.positionMasterService.findByNameContainingIgnoreCase(positionName)) != null && positionList.size() > 0) {
                return "POSITIONNAMEALREADYEXIST";
            }
            positionObj.setName(positionName);
            if (isoutsourced != null && isoutsourced.equalsIgnoreCase("TRUE")) {
                if (!positionObj.getIsPostOutsourced()) {
                    positionObj.setIsPostOutsourced(true);
                    positionObj.getDeptDesig().setOutsourcedPosts(Integer.valueOf(positionObj.getDeptDesig().getOutsourcedPosts() != null ? positionObj.getDeptDesig().getOutsourcedPosts() + 1 : 1));
                }
            } else if (positionObj.getIsPostOutsourced()) {
                positionObj.setIsPostOutsourced(false);
                positionObj.getDeptDesig().setOutsourcedPosts(Integer.valueOf(positionObj.getDeptDesig().getOutsourcedPosts() != null ? positionObj.getDeptDesig().getOutsourcedPosts() - 1 : 0));
            }
            this.positionMasterService.updatePosition(positionObj);
            return "SUCCESS";
        }
        if (positionName == null) {
            return "POSITIONNAMEISNULL";
        }
        return "SUCCESS";
    }

    @RequestMapping(value={"resultList-update"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long departmentId = 0L;
        Long designationId = 0L;
        if (request.getParameter("departmentId") != null && !"".equals(request.getParameter("departmentId"))) {
            departmentId = Long.valueOf(request.getParameter("departmentId"));
        }
        if (request.getParameter("designationId") != null && !"".equals(request.getParameter("designationId"))) {
            designationId = Long.valueOf(request.getParameter("designationId"));
        }
        String complaintRouterJSONData = this.commonSearchResult(departmentId, designationId);
        response.setContentType("application/json");
        IOUtils.write((String)complaintRouterJSONData, (Writer)response.getWriter());
    }

    public String commonSearchResult(Long departmentId, Long designationId) {
        List positionList = this.positionMasterService.getPageOfPositions(departmentId, designationId);
        StringBuilder PositionJSONData = new StringBuilder("{\"data\":").append(WebUtils.toJSON((Collection)positionList, Position.class, PositionAdaptor.class)).append("}");
        return PositionJSONData.toString();
    }

    @RequestMapping(value={"search"}, method={RequestMethod.POST})
    public String searchPosition(@Valid @ModelAttribute DeptDesig deptDesig, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "position-search";
        }
        DeptDesig departmentDesignation = this.deptDesigService.findByDepartmentAndDesignation(deptDesig.getDepartment().getId(), deptDesig.getDesignation().getId());
        if (departmentDesignation == null) {
            model.addAttribute(WARNING, (Object)POSITION_NOT_PRESENT);
            model.addAttribute("deptDesig", (Object)new DeptDesig());
            model.addAttribute("mode", (Object)"error");
            return "position-search";
        }
        List positionList = this.positionMasterService.getAllPositionsByDeptDesigId(departmentDesignation.getId());
        model.addAttribute("deptDesig", (Object)departmentDesignation);
        model.addAttribute("positions", (Object)positionList);
        return "position-search";
    }
}

