/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.employee;

import java.io.IOException;
import java.util.Arrays;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.eis.repository.EmployeeTypeRepository;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.JurisdictionService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.postgresql.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/employee"})
public class ViewAndUpdateEmployeController {
    private static final Logger LOGGER = Logger.getLogger(ViewAndUpdateEmployeController.class);
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EmployeeTypeRepository employeeTypeRepository;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private JurisdictionService jurisdictionService;
    @Autowired
    private MessageSource messageSource;

    @ModelAttribute
    public Employee employeeModel(@PathVariable String code) {
        return this.employeeService.getEmployeeByCode(code);
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.GET})
    public String edit(Model model, @PathVariable String code) {
        this.setDropDownValues(model);
        model.addAttribute("mode", (Object)"update");
        Employee employee = this.employeeService.getEmployeeByCode(code);
        String image = null;
        if (null != employee.getSignature()) {
            image = Base64.encodeBytes((byte[])employee.getSignature());
        }
        model.addAttribute("image", (Object)image);
        return "employee-form";
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Employee employee, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @RequestParam MultipartFile file, @RequestParam String removedJurisdictionIds, @RequestParam String removedassignIds) {
        Boolean codeExists = this.employeeService.validateEmployeeCode(employee);
        if (codeExists.booleanValue()) {
            errors.rejectValue("code", "Unique.employee.code");
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("mode", (Object)"update");
            return "employee-form";
        }
        try {
            if (!file.isEmpty()) {
                employee.setSignature(file.getBytes());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error in loading Employee Signature" + e.getMessage()), (Throwable)e);
        }
        this.jurisdictionService.removeDeletedJurisdictions(employee, removedJurisdictionIds);
        String positionName = this.employeeService.validatePosition(employee, removedassignIds);
        if (StringUtils.isNotBlank((CharSequence)positionName)) {
            this.setDropDownValues(model);
            String fieldError = this.messageSource.getMessage("position.exists.workflow", (Object[])new String[]{positionName}, null);
            model.addAttribute("error", (Object)fieldError);
            return "employee-form";
        }
        String image = null;
        if (null != employee.getSignature()) {
            image = Base64.encodeBytes((byte[])employee.getSignature());
        }
        model.addAttribute("image", (Object)image);
        this.employeeService.update(employee);
        redirectAttrs.addFlashAttribute("employee", (Object)employee);
        model.addAttribute("message", (Object)"Employee updated successfully");
        return "employee-success";
    }

    @RequestMapping(value={"/view/{code}"}, method={RequestMethod.GET})
    public String view(@PathVariable String code, Model model) {
        Employee employee = this.employeeService.getEmployeeByCode(code);
        String image = null;
        if (null != employee.getSignature()) {
            image = Base64.encodeBytes((byte[])employee.getSignature());
        }
        model.addAttribute("image", (Object)image);
        return "employee-success";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("employeeStatus", Arrays.asList(EmployeeStatus.values()));
        model.addAttribute("department", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("employeeTypes", (Object)this.employeeTypeRepository.findAll());
        model.addAttribute("fundList", (Object)this.employeeService.getAllFunds());
        model.addAttribute("functionaryList", (Object)this.employeeService.getAllFunctionaries());
        model.addAttribute("functionList", (Object)this.employeeService.getAllFunctions());
        model.addAttribute("gradeList", (Object)this.employeeService.getAllGrades());
        model.addAttribute("boundaryType", (Object)this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION"));
    }
}

