/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.masters.designation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.egov.eis.service.DesignationService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.DesignationAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/designation"})
public class CreateAndViewDesignationController {
    private final DesignationService designationService;
    public static final String CONTENTTYPE_JSON = "application/json";

    @Autowired
    public CreateAndViewDesignationController(DesignationService designationService) {
        this.designationService = designationService;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String createForm(Model model) {
        model.addAttribute("designation", (Object)new Designation());
        return "designation-form";
    }

    @RequestMapping(value={"view"}, method={RequestMethod.GET})
    public String complaintTypeViewForm(@ModelAttribute Designation designation, Model model) {
        return "designation-view";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String createDesignation(@Valid @ModelAttribute Designation designation, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "designation-form";
        }
        this.designationService.createDesignation(designation);
        redirectAttrs.addFlashAttribute("designation", (Object)designation);
        model.addAttribute("message", (Object)"Designation created successfully");
        return "success-designation";
    }

    public String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Designation.class, (Object)new DesignationAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"ajax/result"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTables(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List designationList = this.designationService.getAllDesignations();
        StringBuilder designationJSONData = new StringBuilder("{\"data\":").append(this.toJSON((Object)designationList)).append("}");
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((CharSequence)designationJSONData, (Writer)response.getWriter());
    }
}

