/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.eis.service.scheduler.jobs.UserRoleMappingJob;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={SchedulerConfigCondition.class})
public class EisSchedulerConfiguration
extends QuartzSchedulerConfiguration {
    @Bean(destroyMethod="destroy")
    public SchedulerFactoryBean eisScheduler(DataSource dataSource) {
        SchedulerFactoryBean eisScheduler = this.createScheduler(dataSource);
        eisScheduler.setSchedulerName("eis-scheduler");
        eisScheduler.setAutoStartup(true);
        eisScheduler.setOverwriteExistingJobs(true);
        return eisScheduler;
    }

    @Bean(value={"userRoleMappingJob"})
    public UserRoleMappingJob userRoleMappingJob() {
        return new UserRoleMappingJob();
    }

    @Bean
    public JobDetailFactoryBean userRoleMappingJobDetail() {
        JobDetailFactoryBean userRoleMappingJobDetail = new JobDetailFactoryBean();
        userRoleMappingJobDetail.setGroup("EIS_JOB_GROUP");
        userRoleMappingJobDetail.setName("EIS_USER_ROLE_MAPPING_JOB");
        userRoleMappingJobDetail.setDurability(true);
        userRoleMappingJobDetail.setJobClass(UserRoleMappingJob.class);
        userRoleMappingJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "userRoleMappingJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "false");
        jobDetailMap.put("moduleName", "eis");
        userRoleMappingJobDetail.setJobDataAsMap(jobDetailMap);
        return userRoleMappingJobDetail;
    }
}

