/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.workflow;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.AssignmentAdaptor;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxWorkFlowController {
    @Autowired
    private CustomizedWorkFlowService customizedWorkFlowService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AssignmentService assignmentService;

    @RequestMapping(value={"/ajaxWorkFlow-getDesignationsByObjectType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignationsByObjectType(@ModelAttribute(value="designations") @RequestParam String departmentRule, @RequestParam String currentState, @RequestParam String type, @RequestParam String amountRule, @RequestParam String additionalRule, @RequestParam String pendingAction, @RequestParam Long approvalDepartment) {
        List<Designation> designationList = this.designationService.getDesignationsByNames(this.customizedWorkFlowService.getNextDesignations(type, departmentRule, null, additionalRule, currentState, pendingAction, new Date()));
        if (designationList.isEmpty()) {
            designationList = this.designationService.getAllDesignationByDepartment(approvalDepartment, new Date());
        }
        return designationList;
    }

    @RequestMapping(value={"/ajaxWorkFlow-getDesignationsForActiveAssignmentsByObjectType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignationsForActiveAssignmentsByObjectType(@ModelAttribute(value="designations") @RequestParam String departmentRule, @RequestParam String currentState, @RequestParam String type, @RequestParam String amountRule, @RequestParam String additionalRule, @RequestParam String pendingAction, @RequestParam Long approvalDepartment) {
        List<Designation> designationList = this.assignmentService.getDesignationsByActiveAssignmentAndDesignationNames(this.customizedWorkFlowService.getNextDesignationsForActiveAssignments(type, departmentRule, null, additionalRule, currentState, pendingAction, new Date()));
        if (designationList.isEmpty()) {
            designationList = this.designationService.getAllDesignationByDepartment(approvalDepartment, new Date());
        }
        return designationList;
    }

    @RequestMapping(value={"/ajaxWorkFlow-getDesignationsForActiveAssignmentsByObjectTypeAndDesignation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignationsForActiveAssignmentsByObjectTypeAndDesignation(@ModelAttribute(value="designations") @RequestParam String departmentRule, @RequestParam String currentState, @RequestParam String type, @RequestParam String amountRule, @RequestParam String additionalRule, @RequestParam String pendingAction, @RequestParam Long approvalDepartment, @RequestParam String currentDesignation) {
        List<Designation> designationList = this.assignmentService.getDesignationsByActiveAssignmentAndDesignationNames(this.customizedWorkFlowService.getNextDesignationsForActiveAssignments(type, departmentRule, null, additionalRule, currentState, pendingAction, new Date(), currentDesignation));
        if (designationList.isEmpty()) {
            designationList = this.designationService.getAllDesignationByDepartment(approvalDepartment, new Date());
        }
        return designationList;
    }

    @RequestMapping(value={"/ajaxWorkFlow-getDesignationsByObjectTypeAndDesignation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Designation> getDesignationsByObjectTypeAndDesignation(@ModelAttribute(value="designations") @RequestParam String departmentRule, @RequestParam String currentState, @RequestParam String type, @RequestParam String amountRule, @RequestParam String additionalRule, @RequestParam String pendingAction, @RequestParam Long approvalDepartment, @RequestParam String currentDesignation) {
        List<Designation> designationList = this.designationService.getDesignationsByNames(this.customizedWorkFlowService.getNextDesignations(type, departmentRule, null, additionalRule, currentState, pendingAction, new Date(), currentDesignation));
        if (designationList.isEmpty()) {
            designationList = this.designationService.getAllDesignationByDepartment(approvalDepartment, new Date());
        }
        return designationList;
    }

    @RequestMapping(value={"/ajaxWorkFlow-positionsByDepartmentAndDesignation"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getWorkFlowPositionByDepartmentAndDesignation(@RequestParam Long approvalDepartment, @RequestParam Long approvalDesignation) {
        if (approvalDepartment != null && approvalDepartment != 0L && approvalDepartment != -1L && approvalDesignation != null && approvalDesignation != 0L && approvalDesignation != -1L) {
            List<Assignment> assignmentList = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(approvalDepartment, approvalDesignation, new Date());
            Gson jsonCreator = new GsonBuilder().registerTypeAdapter(Assignment.class, (Object)new AssignmentAdaptor()).create();
            return jsonCreator.toJson(assignmentList, new TypeToken<Collection<Assignment>>(){}.getType());
        }
        return "[]";
    }
}

