/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.egov.eis.entity.Assignment;
import org.egov.eis.repository.PositionHierarchyRepository;
import org.egov.eis.repository.PositionMasterRepository;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.utils.PersistenceUtils;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PositionMasterService {
    private final PositionMasterRepository positionMasterRepository;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionHierarchyRepository positionHierarchyRepository;

    @Autowired
    public PositionMasterService(PositionMasterRepository positionMasterRepository) {
        this.positionMasterRepository = positionMasterRepository;
    }

    @Transactional
    public void createPosition(Position position) {
        this.positionMasterRepository.save(position);
    }

    @Transactional
    public void updatePosition(Position position) {
        this.positionMasterRepository.save(position);
    }

    @Transactional
    public void deletePosition(Position position) {
        this.positionMasterRepository.delete(position);
    }

    public Position getPositionByName(String name) {
        return this.positionMasterRepository.findByName(name);
    }

    public Position getPositionById(Long posId) {
        return (Position)this.positionMasterRepository.findOne(posId);
    }

    public List<Position> getAllPositions() {
        return this.positionMasterRepository.findAll();
    }

    public List<Position> getAllPositionsByNameLike(String name) {
        return this.positionMasterRepository.findByNameContainingIgnoreCase(name);
    }

    public List<Position> getAllPositionsByDeptDesigId(Long deptDesigId) {
        return this.positionMasterRepository.findAllByDeptDesig_Id(deptDesigId);
    }

    public List<Position> getPositionsForDeptDesigAndName(Long departmentId, Long designationId, Date fromDate, Date toDate, String posName) {
        List<Assignment> assignList = this.assignmentService.getAssignmentsByDeptDesigAndDates(departmentId, designationId, fromDate, toDate);
        List<Position> posList = this.positionMasterRepository.findByDeptDesig_Department_IdAndDeptDesig_Designation_IdAndNameContainingIgnoreCase(departmentId, designationId, posName);
        for (Assignment assign : assignList) {
            posList.removeIf(m -> m.getId() == assign.getPosition().getId());
        }
        return posList;
    }

    public List<Position> getPositionsForDeptDesigAndNameLike(Long departmentId, Long designationId, String posName) {
        return this.positionMasterRepository.findByDeptDesig_Department_IdAndDeptDesig_Designation_IdAndNameContainingIgnoreCase(departmentId, designationId, posName);
    }

    public boolean validatePosition(Position position) {
        List<Position> positionList;
        return position == null || position.getName() == null || (positionList = this.positionMasterRepository.findByNameContainingIgnoreCase(position.getName())).isEmpty();
    }

    public List<Position> getPageOfPositions(Long departmentId, Long designationId) {
        if (departmentId != 0L && designationId != 0L) {
            return this.positionMasterRepository.findPositionBydepartmentAndDesignation(departmentId, designationId);
        }
        if (departmentId != 0L) {
            return this.positionMasterRepository.findPositionBydepartment(departmentId);
        }
        if (designationId != 0L) {
            return this.positionMasterRepository.findPositionByDesignation(designationId);
        }
        return this.positionMasterRepository.findPositionByAll();
    }

    public List<Position> findByNameContainingIgnoreCase(String positionName) {
        return this.positionMasterRepository.findByNameContainingIgnoreCase(positionName);
    }

    public Integer getTotalOutSourcedPosts(Long departmentId, Long designationId) {
        if (departmentId != 0L && designationId != 0L) {
            return this.positionMasterRepository.getTotalOutSourcedPostsByDepartmentAndDesignation(departmentId, designationId);
        }
        if (designationId != 0L) {
            return this.positionMasterRepository.getTotalOutSourcedPostsByDesignation(designationId);
        }
        if (departmentId != 0L) {
            return this.positionMasterRepository.getTotalOutSourcedPostsByDepartment(departmentId);
        }
        return this.positionMasterRepository.getTotalOutSourcedPosts();
    }

    public Integer getTotalSanctionedPosts(Long departmentId, Long designationId) {
        if (departmentId != 0L && designationId != 0L) {
            return this.positionMasterRepository.getTotalSanctionedPostsByDepartmentAndDesignation(departmentId, designationId);
        }
        if (designationId != 0L) {
            return this.positionMasterRepository.getTotalSanctionedPostsByDesignation(designationId);
        }
        if (departmentId != 0L) {
            return this.positionMasterRepository.getTotalSanctionedPostsByDepartment(departmentId);
        }
        return this.positionMasterRepository.getTotalSanctionedPosts();
    }

    public List<Position> getPositionsByDepartmentAndDesignationForGivenRange(Long departmentId, Long designationId, Date givenDate) {
        ArrayList<Position> positionList = new ArrayList<Position>();
        List<Assignment> assignmentList = this.assignmentService.getPositionsByDepartmentAndDesignationForGivenRange(departmentId, designationId, givenDate);
        for (Assignment assignmentObj : assignmentList) {
            positionList.add((Position)PersistenceUtils.unproxy((Object)assignmentObj.getPosition()));
        }
        return positionList;
    }

    public List<Position> getPositionsByDepartmentAndDesignationId(Long departmentId, Long designationId) {
        return this.getPositionsByDepartmentAndDesignationForGivenRange(departmentId, designationId, new Date());
    }

    public Position getCurrentPositionForUser(Long userId) {
        Assignment assign = this.assignmentService.getPrimaryAssignmentForEmployee(userId);
        if (assign != null) {
            return assign.getPosition();
        }
        return null;
    }

    public Position getSuperiorPositionByObjectTypeAndPositionFrom(Integer objectId, Long posId) {
        return this.positionHierarchyRepository.getPositionHierarchyByPosAndObjectType(posId, objectId).getToPosition();
    }

    public Position getSuperiorPositionByObjectAndObjectSubTypeAndPositionFrom(Integer objectId, String objectSubType, Long posId) {
        return this.positionHierarchyRepository.getPosHirByPosAndObjectTypeAndObjectSubType(posId, objectId, objectSubType).getToPosition();
    }

    public List<Position> getPositionsForEmployee(Long employeeId, Date forDate) {
        Date userGivenDate = null == forDate ? new Date() : forDate;
        HashSet<Position> positions = new HashSet<Position>();
        List<Assignment> assignments = this.assignmentService.findByEmployeeAndGivenDate(employeeId, userGivenDate);
        for (Assignment assign : assignments) {
            positions.add(assign.getPosition());
        }
        return new ArrayList<Position>(positions);
    }

    public List<Position> getPositionsForEmployee(Long employeeId) {
        HashSet<Position> positions = new HashSet<Position>();
        List<Assignment> assignList = this.assignmentService.getAllAssignmentsByEmpId(employeeId);
        for (Assignment assign : assignList) {
            positions.add(assign.getPosition());
        }
        return new ArrayList<Position>(positions);
    }

    public List<Position> getCurrentUserPositions() {
        return this.getPositionsForEmployee(ApplicationThreadLocals.getUserId());
    }

    public Position getPositionByUserId(Long userId) {
        Assignment assignment = this.assignmentService.getPrimaryAssignmentForUser(userId);
        if (assignment != null) {
            return assignment.getPosition();
        }
        return null;
    }

    public Position getPrimaryAssignmentPositionForEmp(Long empId) {
        return this.assignmentService.getPrimaryAssignmentForEmployee(empId).getPosition();
    }

    public String generatePositionByDeptDesig(Department department, Designation designation) {
        String name = department.getCode() + "_" + designation.getCode() + "_";
        name = name + (this.positionMasterRepository.getPositionSerialNumberByName(name) + 1);
        return name;
    }

    public List<Position> getPositionsByDepartment(Long deptId) {
        ArrayList<Position> positionList = new ArrayList<Position>();
        List<Assignment> assignmentList = this.assignmentService.findAssignmentForDepartmentId(deptId);
        for (Assignment assignmentObj : assignmentList) {
            positionList.add(assignmentObj.getPosition());
        }
        return positionList;
    }

    public List<Position> getPositionsByDesignation(Long desigId) {
        ArrayList<Position> positionList = new ArrayList<Position>();
        List<Assignment> assignmentList = this.assignmentService.findAssignmentForDesignationId(desigId);
        for (Assignment assignmentObj : assignmentList) {
            positionList.add(assignmentObj.getPosition());
        }
        return positionList;
    }

    public List<Position> getPositionsByDepartmentAndDesignation(Long deptId, Long desigId) {
        ArrayList<Position> positionList = new ArrayList<Position>();
        List<Assignment> assignmentList = this.assignmentService.findByDepartmentAndDesignation(deptId, desigId);
        for (Assignment assignmentObj : assignmentList) {
            positionList.add(assignmentObj.getPosition());
        }
        return positionList;
    }
}

