/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.Collections;
import java.util.List;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.repository.PositionHierarchyRepository;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PositionHierarchyService {
    private final PositionHierarchyRepository positionHierarchyRepository;

    @Autowired
    public PositionHierarchyService(PositionHierarchyRepository positionHierarchyRepository) {
        this.positionHierarchyRepository = positionHierarchyRepository;
    }

    @Transactional
    public void createPositionHierarchy(PositionHierarchy positionHierarchy) {
        this.positionHierarchyRepository.save((Object)positionHierarchy);
    }

    @Transactional
    public void updatePositionHierarchy(PositionHierarchy positionHierarchy) {
        this.positionHierarchyRepository.save((Object)positionHierarchy);
    }

    public PositionHierarchy getPositionHierarchyByPosAndObjectType(Long posId, Integer objectId) {
        return this.positionHierarchyRepository.getPositionHierarchyByPosAndObjectType(posId, objectId);
    }

    public PositionHierarchy getPosHirByPosAndObjectTypeAndObjectSubType(Long posId, Integer objectId, String objectSubType) {
        return this.positionHierarchyRepository.getPosHirByPosAndObjectTypeAndObjectSubType(posId, objectId, objectSubType);
    }

    public void deleteAllInBatch(List<PositionHierarchy> existingPosHierarchy) {
        this.positionHierarchyRepository.deleteInBatch(existingPosHierarchy);
    }

    public List<PositionHierarchy> getPositionHeirarchyByFromPositionAndObjectType(Long fromPositionId, Integer objectId) {
        return this.positionHierarchyRepository.getListOfPositionHeirarchyByFromPositionAndObjectType(fromPositionId, objectId);
    }

    public List<PositionHierarchy> getListOfPositionHeirarchyByFromPositionAndObjectTypeAndSubType(Long fromPositionId, Integer objectId, String objectSubType) {
        if (fromPositionId != 0L && objectId != 0 && objectSubType != null) {
            return this.positionHierarchyRepository.getListOfPositionHeirarchyByFromPositionAndObjectTypeAndSubType(fromPositionId, objectId, objectSubType);
        }
        if (fromPositionId == 0L && objectId != 0 && objectSubType != null) {
            return this.positionHierarchyRepository.getPosHirByObjectTypeAndObjectSubType(objectId, objectSubType);
        }
        if (fromPositionId != 0L && objectId != 0 && objectSubType == null) {
            return this.positionHierarchyRepository.getListOfPositionHeirarchyByFromPositionAndObjectType(fromPositionId, objectId);
        }
        if (fromPositionId == 0L && objectId != 0 && objectSubType == null) {
            return this.positionHierarchyRepository.getListOfPositionHeirarchyByObjectType(objectId);
        }
        return Collections.emptyList();
    }

    public List<PositionHierarchy> getListOfPositionHeirarchyByPositionObjectTypeSubType(Integer objectType, List<String> objectSubTypes, Position fromPositionId) {
        return this.positionHierarchyRepository.findPositionHierarchyByObjectSubTypeAndFromPosition(objectType, objectSubTypes, fromPositionId);
    }
}

