/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.List;
import org.egov.eis.entity.EmployeeType;
import org.egov.eis.repository.EmployeeTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EmployeeTypeService {
    private final EmployeeTypeRepository employeeTypeRepository;

    @Autowired
    public EmployeeTypeService(EmployeeTypeRepository employeeTypeRepository) {
        this.employeeTypeRepository = employeeTypeRepository;
    }

    public EmployeeType getEmployeeTypeByName(String name) {
        return this.employeeTypeRepository.findByName(name);
    }

    public List<EmployeeType> getEmployeeTypeByChartOfAccounts(Long coaId) {
        return this.employeeTypeRepository.findByChartOfAccounts_Id(coaId);
    }

    public List<EmployeeType> getAllEmployeeTypes() {
        return this.employeeTypeRepository.findAll();
    }

    public EmployeeType getEmployeeTypeById(Long id) {
        return (EmployeeType)((Object)this.employeeTypeRepository.findOne(id));
    }

    @Transactional
    public void create(EmployeeType employeeType) {
        this.employeeTypeRepository.save((Object)employeeType);
    }

    @Transactional
    public void update(EmployeeType employeeType) {
        this.employeeTypeRepository.save((Object)employeeType);
    }

    @Transactional
    public void delete(EmployeeType employeeType) {
        this.employeeTypeRepository.delete((Object)employeeType);
    }
}

