/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.EmployeeSearchDTO;
import org.egov.eis.entity.HeadOfDepartments;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.eis.repository.AssignmentRepository;
import org.egov.eis.repository.EmployeeRepository;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.repository.UserRepository;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.EnvironmentSettings;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.service.StateHistoryService;
import org.egov.infra.workflow.service.StateService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EmployeeService
implements EntityTypeService {
    private final EmployeeRepository employeeRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private AssignmentRepository assignmentRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private EnvironmentSettings environmentSettings;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private UserService userService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private StateService stateService;
    @Autowired
    private StateHistoryService stateHistoryService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private DepartmentService departmentService;

    @Autowired
    public EmployeeService(EmployeeRepository employeeRepository) {
        this.employeeRepository = employeeRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<CFunction> getAllFunctions() {
        return this.getCurrentSession().createQuery("from CFunction where isactive = true AND isnotleaf=false order by upper(name)").list();
    }

    public List<Functionary> getAllFunctionaries() {
        return this.getCurrentSession().createQuery("from Functionary where isactive=true order by upper(name)").list();
    }

    public List<Fund> getAllFunds() {
        return this.getCurrentSession().createQuery("from Fund where isactive = true and isNotLeaf!=true order by upper(name)").list();
    }

    public List<Fund> getAllGrades() {
        return this.getCurrentSession().createQuery("from GradeMaster order by name").list();
    }

    public List<EntityType> getAllActiveEntities(Integer employeeId) {
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        List<Employee> employees = this.getAllEmployees();
        entities.addAll(employees);
        return entities;
    }

    @Transactional
    public void create(Employee employee) {
        employee.updateNextPwdExpiryDate(this.environmentSettings.userPasswordExpiryInDays());
        employee.setPassword(this.passwordEncoder.encode((CharSequence)"12345678"));
        List user = new ArrayList();
        employee.setAssignments(employee.getAssignments().parallelStream().filter(assignment -> assignment.getPosition() != null).collect(Collectors.toList()));
        for (Assignment assign : employee.getAssignments()) {
            assign.setEmployee(employee);
            assign.setDepartment(assign.getDepartment());
            Set<Role> roles = this.designationService.getRolesByDesignation(assign.getDesignation().getName());
            for (Role role : roles) {
                user = this.userService.getUsersByUsernameAndRolename(employee.getUsername(), this.roleService.getRoleByName(role.getName()).getName());
                if (!assign.getFromDate().before(new Date()) || !assign.getToDate().after(new Date()) || !user.isEmpty() && user != null) continue;
                employee.addRole(this.roleService.getRoleByName(role.getName()));
            }
            for (HeadOfDepartments hod : assign.getDeptSet()) {
                hod.setAssignment(assign);
            }
        }
        employee.setJurisdictions(employee.getJurisdictions().parallelStream().filter(Jurisdictions -> Jurisdictions.getBoundaryType() != null && Jurisdictions.getBoundary() != null).collect(Collectors.toList()));
        for (Jurisdiction jurisdiction : employee.getJurisdictions()) {
            jurisdiction.setEmployee(employee);
            jurisdiction.setBoundaryType(jurisdiction.getBoundaryType());
            jurisdiction.setBoundary(jurisdiction.getBoundary());
        }
        employee.getRoles().add(this.roleService.getRoleByName("EMPLOYEE"));
        this.employeeRepository.save((Object)employee);
    }

    @Transactional
    public void createEmployeeData(Employee employee) {
        employee.updateNextPwdExpiryDate(this.environmentSettings.userPasswordExpiryInDays());
        employee.setPassword(this.passwordEncoder.encode((CharSequence)"12345678"));
        employee.getRoles().add(this.roleService.getRoleByName("EMPLOYEE"));
        this.employeeRepository.save((Object)employee);
    }

    @Transactional
    public void update(Employee employee) {
        for (Assignment assign : employee.getAssignments()) {
            assign.getDeptSet().clear();
            for (HeadOfDepartments hod : assign.getHodList()) {
                hod.setAssignment(assign);
                hod.setHod(this.departmentService.getDepartmentById(hod.getHod().getId()));
                assign.getDeptSet().add(hod);
            }
            assign.setEmployee(employee);
            assign.setDepartment(assign.getDepartment());
        }
        for (Jurisdiction jurisdiction : employee.getJurisdictions()) {
            jurisdiction.setEmployee(employee);
            jurisdiction.setBoundaryType(jurisdiction.getBoundaryType());
            jurisdiction.setBoundary(jurisdiction.getBoundary());
        }
        this.employeeRepository.saveAndFlush((Object)employee);
    }

    @Transactional
    public void updateEmployeeDetails(Employee employee) {
        this.employeeRepository.saveAndFlush((Object)employee);
    }

    @Transactional
    public void addOrRemoveUserRole() {
        List<Employee> employee = this.getAllEmployees();
        for (Employee emp : employee) {
            Set userRole = this.userService.getRolesByUsername(emp.getUsername());
            Set<Role> expiredRoleList = this.assignmentService.getRolesForExpiredAssignmentsByEmpId(emp.getId());
            Set<Role> activeRoleList = this.assignmentService.getRolesForActiveAssignmentsByEmpId(emp.getId());
            expiredRoleList.removeAll(activeRoleList);
            userRole.removeAll(expiredRoleList);
            userRole.addAll(activeRoleList);
            emp.setRoles(userRole);
            this.employeeRepository.save((Object)emp);
        }
    }

    public List<Employee> searchEmployees(EmployeeSearchDTO searchParams) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("select distinct(assign.employee) from Assignment assign where assign.id is not null ");
        if (StringUtils.isNotBlank((CharSequence)searchParams.getCode())) {
            queryString.append(" AND assign.employee.code =:code ");
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getName())) {
            queryString.append(" AND assign.employee.name like :name ");
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getAadhaar())) {
            queryString.append(" AND assign.employee.aadhaar = :aadhaar");
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getMobileNumber())) {
            queryString.append(" AND assign.employee.mobileNumber = :mobileNumber");
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getPan())) {
            queryString.append(" AND assign.employee.pan = :pan");
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getEmail())) {
            queryString.append(" AND assign.employee.emailId = :email");
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getStatus())) {
            queryString.append(" AND assign.employee.employeeStatus = :status");
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getEmployeeType())) {
            queryString.append(" AND assign.employee.employeeType.name = :type");
        }
        if (searchParams.getDepartment() != null) {
            queryString.append(" AND assign.department.name =:department ");
        }
        if (searchParams.getDesignation() != null) {
            queryString.append(" AND assign.designation.name =:designation ");
        }
        if (searchParams.getFunctionary() != null) {
            queryString.append(" AND assign.functionary.name =:functionary ");
        }
        if (searchParams.getFunction() != null) {
            queryString.append(" AND assign.function.name =:function ");
        }
        if (searchParams.getIsHOD().booleanValue()) {
            queryString.append(" and assign.id  in (select assignment.id from HeadOfDepartments )");
        }
        queryString.append(" Order by assign.employee.code, assign.employee.name ");
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString());
        query = this.setParametersToQuery(searchParams, query);
        List employees = query.list();
        return employees;
    }

    public Query setParametersToQuery(EmployeeSearchDTO searchParams, Query query) {
        if (StringUtils.isNotBlank((CharSequence)searchParams.getCode())) {
            query.setParameter("code", (Object)searchParams.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getName())) {
            query.setParameter("name", (Object)searchParams.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getAadhaar())) {
            query.setParameter("aadhaar", (Object)searchParams.getAadhaar());
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getMobileNumber())) {
            query.setParameter("mobileNumber", (Object)searchParams.getMobileNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getPan())) {
            query.setParameter("pan", (Object)searchParams.getPan());
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getEmail())) {
            query.setParameter("email", (Object)searchParams.getEmail());
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getStatus())) {
            query.setParameter("status", (Object)searchParams.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)searchParams.getEmployeeType())) {
            query.setParameter("aadhaar", (Object)searchParams.getEmployeeType());
        }
        return this.setAssignmentParameter(searchParams, query);
    }

    public Query setAssignmentParameter(EmployeeSearchDTO searchParams, Query assignQuery) {
        if (searchParams.getDepartment() != null) {
            assignQuery.setParameter("department", (Object)searchParams.getDepartment());
        }
        if (searchParams.getDesignation() != null) {
            assignQuery.setParameter("designation", (Object)searchParams.getDesignation());
        }
        if (searchParams.getFunctionary() != null) {
            assignQuery.setParameter("functionary", (Object)searchParams.getFunctionary());
        }
        if (searchParams.getFunction() != null) {
            assignQuery.setParameter("function", (Object)searchParams.getFunction());
        }
        return assignQuery;
    }

    @Transactional
    public void delete(Employee employee) {
        this.employeeRepository.delete((Object)employee);
    }

    public Employee getEmployeeById(Long id) {
        return (Employee)((Object)this.employeeRepository.findOne(id));
    }

    public Employee getEmployeeByCode(String code) {
        return this.employeeRepository.findByCode(code);
    }

    public List<Employee> getEmployeesByStatus(EmployeeStatus status) {
        return this.employeeRepository.findByEmployeeStatus(status);
    }

    public List<Employee> getEmployeesByType(Long id) {
        return this.employeeRepository.findByEmployeeType_Id(id);
    }

    public Employee getEmployeeByUserName(String userName) {
        return this.employeeRepository.findByUsername(userName);
    }

    public List<Employee> findByDepartmentDesignationAndBoundary(Long deptId, Long desigId, Long boundaryId) {
        HashSet<Long> bndIds = new HashSet<Long>();
        List boundaries = this.boundaryService.findActiveChildrenWithParent(boundaryId);
        boundaries.forEach(bndry -> bndIds.add(bndry.getId()));
        return this.employeeRepository.findByDepartmentDesignationAndBoundary(deptId, desigId, bndIds);
    }

    public List<Employee> getEmployeesForPosition(Long posId) {
        HashSet<Employee> employees = new HashSet<Employee>();
        List<Assignment> assignList = this.assignmentRepository.getAssignmentsForPosition(posId);
        for (Assignment assign : assignList) {
            employees.add(assign.getEmployee());
        }
        return new ArrayList<Employee>(employees);
    }

    public Employee getPrimaryAssignmentEmployeeForPos(Long posId) {
        return this.assignmentRepository.getPrimaryAssignmentForPosition(posId).getEmployee();
    }

    public Employee getEmployeeForPositionAndDate(Long posId, Date givenDate) {
        return this.assignmentRepository.getPrimaryAssignmentForPositionAndDate(posId, givenDate).getEmployee();
    }

    public List<Employee> getAllEmployees() {
        return this.employeeRepository.findAll();
    }

    public List<? extends EntityType> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        return this.employeeRepository.findByNameLikeOrCodeLike(filterKey + "%", filterKey + "%");
    }

    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    public List<? extends EntityType> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    public List<? extends EntityType> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }

    public String generateUserNameByDeptDesig(Department department, Designation designation) {
        String name = department.getCode() + designation.getCode();
        name = name + (this.userRepository.getUserSerialNumberByName(name) + 1);
        return name;
    }

    public List<Employee> findEmployeeByCodeLike(String code) {
        return this.employeeRepository.findEmployeeByCodeLike(code);
    }

    public List<Employee> findActiveEmployeeByCodeLike(String code) {
        return this.employeeRepository.findActiveEmployeeByCodeLike(code);
    }

    public String validatePosition(Employee employee, String removedassignIds) {
        boolean positionExistsInWF = false;
        boolean positionExistsInWFHistory = false;
        List<Position> updatedPositionList = this.positionMasterService.getPositionsForEmployee(employee.getId());
        if (StringUtils.isNotBlank((CharSequence)removedassignIds)) {
            String[] deletedAssignIds;
            for (String assignId : deletedAssignIds = removedassignIds.split(",")) {
                Assignment assignment2 = this.assignmentService.getAssignmentById(Long.valueOf(assignId));
                if (assignment2 != null && !assignment2.equals("")) {
                    positionExistsInWF = this.stateService.isPositionUnderWorkflow(assignment2.getPosition().getId(), assignment2.getFromDate());
                    positionExistsInWFHistory = this.stateHistoryService.isPositionUnderWorkflowHistory(assignment2.getPosition().getId(), assignment2.getFromDate());
                }
                if (!positionExistsInWF && !positionExistsInWFHistory) continue;
                return assignment2.getPosition().getName();
            }
        }
        this.assignmentService.removeDeletedAssignments(employee, removedassignIds);
        employee.setAssignments(employee.getAssignments().parallelStream().filter(assignment -> assignment.getPosition() != null).collect(Collectors.toList()));
        employee.setJurisdictions(employee.getJurisdictions().parallelStream().filter(Jurisdictions -> Jurisdictions.getBoundaryType() != null && Jurisdictions.getBoundary() != null).collect(Collectors.toList()));
        this.getCurrentSession().evict((Object)employee);
        Employee updatedEmployee = this.getEmployeeById(employee.getId());
        List<Assignment> oldAssignmentList = this.assignmentService.getAllAssignmentsByEmpId(updatedEmployee.getId());
        List<Position> oldPositionList = this.positionMasterService.getPositionsForEmployee(updatedEmployee.getId());
        oldPositionList.removeAll(updatedPositionList);
        for (Assignment assign : oldAssignmentList) {
            if (!oldPositionList.contains(assign.getPosition())) continue;
            positionExistsInWF = this.stateService.isPositionUnderWorkflow(assign.getPosition().getId(), assign.getFromDate());
            positionExistsInWFHistory = this.stateHistoryService.isPositionUnderWorkflowHistory(assign.getPosition().getId(), assign.getFromDate());
            if (!positionExistsInWF && !positionExistsInWFHistory) continue;
            return assign.getPosition().getName();
        }
        return "";
    }

    public Boolean validateEmployeeCode(Employee employee) {
        String employeeCode = employee.getCode().replaceFirst("^0+(?!$)", "");
        List<Employee> employeeList = this.findActiveEmployeeByCodeLike(employeeCode);
        if (!employeeList.isEmpty()) {
            for (Employee emp : employeeList) {
                String empCode = emp.getCode().replaceFirst("^0+(?!$)", "");
                if (emp.getCode().equals(employee.getCode()) || !employeeCode.equals(empCode) || emp.getId().equals(employee.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean primaryAssignmentExists(Employee employee) {
        for (Assignment assignment : employee.getAssignments()) {
            if (!assignment.getPrimary()) continue;
            return true;
        }
        return false;
    }

    public Boolean primaryAssignExistsForSamePeriod(Employee employee) {
        int count = 0;
        Date currentDate = new Date();
        for (Assignment assign : employee.getAssignments()) {
            if (assign.getFromDate() == null || !currentDate.after(assign.getFromDate()) || !currentDate.before(assign.getToDate()) || !assign.getPrimary()) continue;
            ++count;
        }
        return count > 1;
    }

    public Boolean isPositionExistsInWF(String positionName, Boolean isPositionChanged, Date fromDate, Date toDate) {
        Position position = this.positionMasterService.getPositionByName(positionName);
        if (isPositionChanged.booleanValue()) {
            return this.stateService.isPositionUnderWorkflow(position.getId(), fromDate);
        }
        Date maxCreatedDate = this.stateService.getMaxCreatedDateByPositionId(position.getId());
        return maxCreatedDate != null && maxCreatedDate.after(toDate);
    }
}

