/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.egov.eis.entity.Assignment;
import org.egov.eis.repository.AssignmentRepository;
import org.egov.eis.repository.DesignationCustomRepository;
import org.egov.infra.persistence.utils.PersistenceUtils;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;

public class DesignationRepositoryImpl
implements DesignationCustomRepository {
    @Autowired
    private AssignmentRepository assignmentRepository;

    @Override
    public List<Designation> getAllDesignationsByDepartment(Long id, Date givenDate) {
        HashSet<Object> designations = new HashSet<Object>();
        List<Assignment> assignments = this.assignmentRepository.findAllByDepartmentAndDate(id, givenDate);
        for (Assignment assign : assignments) {
            designations.add(PersistenceUtils.unproxy((Object)assign.getDesignation()));
        }
        return new ArrayList<Designation>(designations);
    }

    @Override
    public Designation getEmployeeDesignation(Long positionId) {
        return this.assignmentRepository.getPrimaryAssignmentForPosition(positionId).getDesignation();
    }
}

