/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.repository;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.egov.eis.entity.Assignment;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AssignmentRepository
extends JpaRepository<Assignment, Long> {
    @Query(value=" from Assignment A where A.employee.id =:empId order by A.fromDate")
    public List<Assignment> getAllAssignmentsByEmpId(@Param(value="empId") Long var1);

    @Query(value=" from Assignment A where A.fromDate<=current_date and A.toDate>=current_date and A.employee.id =:empId order by A.fromDate")
    public List<Assignment> getAllActiveAssignmentsByEmpId(@Param(value="empId") Long var1);

    @Query(value=" from Assignment A where A.fromDate<=:givenDate and A.toDate>=:givenDate and A.position.id=:posId order by A.fromDate")
    public List<Assignment> getAssignmentsForPosition(@Param(value="posId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.fromDate<=current_date and A.toDate>=current_date and A.primary=true and A.position.id=:posId")
    public Assignment getPrimaryAssignmentForPosition(@Param(value="posId") Long var1);

    @Query(value=" from Assignment A where A.fromDate<=current_date and A.toDate>=current_date and A.primary=true and A.employee.id=:userId ")
    public Assignment getPrimaryAssignmentForUser(@Param(value="userId") Long var1);

    @Query(value=" from Assignment A where A.fromDate<=:givenDate and A.toDate>=:givenDate and A.primary=true and A.employee.id=:empId ")
    public Assignment getAssignmentByEmpAndDate(@Param(value="empId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.fromDate<=current_date and A.toDate>=current_date and A.primary=true and A.employee.id=:empId")
    public Assignment getPrimaryAssignmentForEmployee(@Param(value="empId") Long var1);

    @Query(value=" from Assignment A where A.position.id=:posId and A.fromDate<=current_date and A.toDate>=current_date order by A.fromDate")
    public List<Assignment> getAssignmentsForPosition(@Param(value="posId") Long var1);

    @Query(value=" from Assignment A where A.position.id=:posId and A.fromDate<=:givenDate and A.toDate>=:givenDate and A.primary=true and A.employee.active=true")
    public Assignment getPrimaryAssignmentForPositionAndDate(@Param(value="posId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.employee.id=:empId and A.primary=true and A.fromDate<=:fromDate and A.toDate>=:toDate")
    public Assignment getPrimaryAssignmentForGivenRange(@Param(value="empId") Long var1, @Param(value="fromDate") Date var2, @Param(value="toDate") Date var3);

    @Query(value=" from Assignment A where A.designation.id=:designationId  and A.department.id=:departmentId and A.primary=true and A.fromDate<=:givenDate and A.toDate>=:givenDate ")
    public List<Assignment> getPrimaryAssignmentForDepartmentAndDesignation(@Param(value="departmentId") Long var1, @Param(value="designationId") Long var2, @Param(value="givenDate") Date var3);

    @Query(value=" from Assignment A where A.designation.id=:designationId  and A.department.id=:departmentId and A.fromDate<=:givenDate and A.toDate>=:givenDate order by A.primary desc")
    public List<Assignment> getAllAssignmentForDepartmentAndDesignation(@Param(value="departmentId") Long var1, @Param(value="designationId") Long var2, @Param(value="givenDate") Date var3);

    @Query(value=" from Assignment A where A.department.id=:departmentId and A.primary=true and A.fromDate<=:givenDate and A.toDate>=:givenDate ")
    public List<Assignment> getPrimaryAssignmentForDepartment(@Param(value="departmentId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.department.id=:departmentId and A.fromDate<=:givenDate and A.toDate>=:givenDate order by A.primary desc")
    public List<Assignment> getAllAssignmentForDepartment(@Param(value="departmentId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.department.id=:departmentId and A.fromDate<=:givenDate and A.toDate>=:givenDate  and A.position.name like '%'||:posName||'%' order by A.primary desc")
    public List<Assignment> getAllAssignmentForDepartmentAndPositionNameLike(@Param(value="departmentId") Long var1, @Param(value="givenDate") Date var2, @Param(value="posName") String var3);

    @Query(value=" from Assignment A where  A.fromDate<=:givenDate and A.toDate>=:givenDate  and A.position.name like '%'||:posName||'%' order by A.primary desc")
    public List<Assignment> getAllAssignmentForPositionNameLike(@Param(value="givenDate") Date var1, @Param(value="posName") String var2);

    @Query(value=" from Assignment A where A.designation.id=:designationId  and A.primary=true and A.fromDate<=:givenDate and A.toDate>=:givenDate ")
    public List<Assignment> getPrimaryAssignmentForDesignation(@Param(value="designationId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.designation.id=:designationId and A.fromDate<=:givenDate and A.toDate>=:givenDate order by A.primary desc")
    public List<Assignment> getAllAssignmentForDesignation(@Param(value="designationId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.department.id=:deptId and A.designation.id=:desigId and ((:fromDate between A.fromDate and A.toDate) or (:toDate between A.fromDate and A.toDate) or (A.fromDate<=:fromDate and A.toDate>=:toDate)) and A.primary=true")
    public List<Assignment> findByDeptDesigAndDates(@Param(value="deptId") Long var1, @Param(value="desigId") Long var2, @Param(value="fromDate") Date var3, @Param(value="toDate") Date var4);

    @Query(value=" from Assignment A where A.department.id=:deptId and A.designation.id=:desigId and  A.fromDate<=:givenDate and A.toDate>=:givenDate ")
    public List<Assignment> findAllAssignmentsByDeptDesigAndGivenDate(@Param(value="deptId") Long var1, @Param(value="desigId") Long var2, @Param(value="givenDate") Date var3);

    @Query(value=" from Assignment A where A.department.id=:deptId and A.fromDate<=:givenDate and A.toDate>=:givenDate order by A.fromDate ")
    public List<Assignment> findAllByDepartmentAndDate(@Param(value="deptId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.employee.id=:empId and A.fromDate<=:givenDate and A.toDate>=:givenDate order by A.fromDate desc")
    public List<Assignment> findByEmployeeAndGivenDate(@Param(value="empId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where A.fromDate<=current_date and A.toDate>=current_date and A.designation.name=:name and A.primary=true")
    public List<Assignment> findPrimaryAssignmentForDesignationName(@Param(value="name") String var1);

    @Query(value=" select ASSIGN from Assignment ASSIGN inner join ASSIGN.employee as EMP inner join EMP.jurisdictions as JRDN  where ASSIGN.designation.id=:desigId and ASSIGN.fromDate<=current_date and ASSIGN.toDate>=current_date  and JRDN.boundary.id in :boundaryIds and ASSIGN.employee.active=true order by ASSIGN.primary desc")
    public List<Assignment> findByDesignationAndBoundary(@Param(value="desigId") Long var1, @Param(value="boundaryIds") Set<Long> var2);

    @Query(value=" select ASSIGN from Assignment ASSIGN inner join ASSIGN.employee as EMP inner join EMP.jurisdictions as JRDN  where ASSIGN.department.id=:deptId and ASSIGN.designation.id=:desigId and ASSIGN.fromDate<=current_date and ASSIGN.toDate>=current_date  and JRDN.boundary.id in :boundaryIds and ASSIGN.employee.active=true order by ASSIGN.primary desc")
    public List<Assignment> findByDepartmentDesignationAndBoundary(@Param(value="deptId") Long var1, @Param(value="desigId") Long var2, @Param(value="boundaryIds") Set<Long> var3);

    @Query(value=" select ASSIGN from Assignment ASSIGN inner join ASSIGN.employee as EMP inner join EMP.jurisdictions as JRDN  where ASSIGN.department.id=:deptId and ASSIGN.fromDate<=current_date and ASSIGN.toDate>=current_date  and JRDN.boundary.id in :boundaryIds and ASSIGN.employee.active=true order by ASSIGN.primary desc")
    public List<Assignment> findByDepartmentAndBoundary(@Param(value="deptId") Long var1, @Param(value="boundaryIds") Set<Long> var2);

    @Query(value=" select ASSIGN from Assignment ASSIGN where ASSIGN.designation.id=:designationId and  ASSIGN.employee.active=true and ASSIGN.fromDate<=current_date and ASSIGN.toDate>=current_date order by ASSIGN.primary desc")
    public List<Assignment> getAllActiveAssignments(@Param(value="designationId") Long var1);

    @Query(value="select assignment.employee from Assignment assignment where  assignment.employee.active=true and assignment.designation.name in (:designation)")
    public Set<User> getUsersByDesignations(@Param(value="designation") String[] var1);

    @Query(value=" select distinct A.designation.roles from  Assignment A where A.fromDate<=current_date and A.toDate<current_date and A.employee.id =:empId")
    public Set<Role> getRolesForExpiredAssignmentsByEmpId(@Param(value="empId") Long var1);

    @Query(value=" select distinct A.designation.roles from  Assignment A where A.fromDate<=current_date and A.toDate>=current_date and A.employee.id =:empId")
    public Set<Role> getRolesForActiveAssignmentsByEmpId(@Param(value="empId") Long var1);

    @Query(value=" select A from Assignment A where A.department.id=:deptId and A.designation.id in :desigIds and A.fromDate<=:givenDate and A.toDate>=:givenDate")
    public List<Assignment> findByDepartmentDesignationsAndGivenDate(@Param(value="deptId") Long var1, @Param(value="desigIds") List<Long> var2, @Param(value="givenDate") Date var3);

    @Query(value=" select distinct A.position from Assignment A where upper(A.position.name) like upper(:positionName) ")
    public List<Position> findEmployeePositions(@Param(value="positionName") String var1);

    @Query(value=" select A from Assignment A, HeadOfDepartments hod where hod.hod.id=:deptId and A.id = hod.assignment.id  and  A.fromDate<=:givenDate and A.toDate>=:givenDate order by A.primary, A.toDate desc")
    public List<Assignment> findAllAssignmentsByHODDeptAndGivenDate(@Param(value="deptId") Long var1, @Param(value="givenDate") Date var2);

    @Query(value=" from Assignment A where  A.primary=true and A.fromDate<=:givenDate and A.toDate>=:givenDate  and A.employee.name like '%'||:empName||'%' order by A.employee.name desc")
    public List<Assignment> getAllAssignmentForEmployeeNameLike(@Param(value="givenDate") Date var1, @Param(value="empName") String var2);

    public List<Assignment> findByDesignationId(Long var1);

    public List<Assignment> findByDepartmentId(Long var1);

    public List<Assignment> findByDepartmentIdAndDesignationId(Long var1, Long var2);

    @Query(value=" from Assignment A where A.position.id=:posId and ((:fromDate between A.fromDate and A.toDate) or (:toDate between A.fromDate and A.toDate) or (A.fromDate>=:fromDate and A.toDate<=:toDate)) and A.primary=true")
    public List<Assignment> getPrimaryAssignmentForPositionAndDateRange(@Param(value="posId") Long var1, @Param(value="fromDate") Date var2, @Param(value="toDate") Date var3);

    @Query(value=" from Assignment A where A.position.id=:posId and A.employee.id = :userId and A.fromDate<=:givenDate and A.toDate>=:givenDate ")
    public List<Assignment> findByPositionAndEmployee(@Param(value="posId") Long var1, @Param(value="userId") Long var2, @Param(value="givenDate") Date var3);

    @Query(value=" from Assignment A where A.designation.id in(select desig.id from Designation desig where desig.code in :designationCode) and A.department.id in (select depart.id from Department depart where depart.code = :departmentCode) and A.fromDate<=:givenDate and A.toDate>=:givenDate ")
    public List<Assignment> findByDepartmentCodeAndDesignationCode(@Param(value="departmentCode") String var1, @Param(value="designationCode") List<String> var2, @Param(value="givenDate") Date var3);

    @Query(value="select distinct A.designation from  Assignment A where A.fromDate<=current_date and A.toDate>=current_date and trim(upper(A.designation.name)) in(:designationNames)")
    public List<Designation> findAllDesignationByActiveAssignmentAndDesignationNames(@Param(value="designationNames") List<String> var1);
}

