/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.egov.eis.repository.DesignationRepository;
import org.egov.infra.admin.master.entity.Role;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DesignationService {
    @Autowired
    private DesignationRepository designationRepository;

    @Transactional
    public void createDesignation(Designation designation) {
        this.designationRepository.save(designation);
    }

    @Transactional
    public void updateDesignation(Designation designation) {
        this.designationRepository.save(designation);
    }

    @Transactional
    public void deleteDesignation(Designation designation) {
        this.designationRepository.delete(designation);
    }

    public Designation getDesignationByName(String desName) {
        return this.designationRepository.findByNameUpperCase(desName.toUpperCase());
    }

    public Designation getDesignationById(Long desigId) {
        return (Designation)this.designationRepository.findOne(desigId);
    }

    public List<Designation> getAllDesignations() {
        return this.designationRepository.findAll();
    }

    public List<Designation> getAllDesignationsSortByNameAsc() {
        return this.designationRepository.findAllByOrderByNameAsc();
    }

    public List<Designation> getAllDesignationsByNameLike(String name) {
        return this.designationRepository.findByNameContainingIgnoreCaseOrderByNameAsc(name);
    }

    public List<Designation> getAllDesignationByDepartment(Long id, Date givenDate) {
        return this.designationRepository.getAllDesignationsByDepartment(id, givenDate);
    }

    public Set<Role> getRolesByDesignation(String designationName) {
        return this.designationRepository.getRolesByDesignation(designationName);
    }

    public List<Designation> getDesignationsByNames(List<String> names) {
        return this.designationRepository.getDesignationsByNames(names);
    }

    public List<Designation> getDesignationsByName(String name) {
        return this.designationRepository.getDesignationsByName("%" + name + "%");
    }
}

