/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.HeadOfDepartments;
import org.egov.eis.repository.HeadOfDepartmentsRepository;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PersonalInformationService;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EisCommonService {
    @Autowired
    private PositionHierarchyService positionHierarchyService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PersonalInformationService personalInformationService;
    @Autowired
    private HeadOfDepartmentsRepository employeeDepartmentRepository;

    @Deprecated
    public Position getSuperiorPositionByObjectTypeAndPositionFrom(Integer objectId, Long posId) {
        return this.positionHierarchyService.getPositionHierarchyByPosAndObjectType(posId, objectId).getToPosition();
    }

    @Deprecated
    public Position getSuperiorPositionByObjectAndObjectSubTypeAndPositionFrom(Integer objectId, String objectSubType, Long posId) {
        return this.positionHierarchyService.getPosHirByPosAndObjectTypeAndObjectSubType(posId, objectId, objectSubType).getToPosition();
    }

    public User getUserForPosition(Long posId, Date givenDate) {
        try {
            return this.assignmentService.getAssignmentsForPosition(posId, givenDate).get(0).getEmployee();
        }
        catch (NullPointerException e) {
            throw new ApplicationRuntimeException("User Not Found");
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public Designation getEmployeeDesignation(Long posId) {
        return this.assignmentService.getPrimaryAssignmentForPositon(posId).getDesignation();
    }

    public Department getDepartmentForUser(Long userId) {
        return this.assignmentService.getPrimaryAssignmentForUser(userId).getDepartment();
    }

    @Deprecated
    public Position getPositionByUserId(Long userId) {
        return this.assignmentService.getPrimaryAssignmentForUser(userId).getPosition();
    }

    @Deprecated
    public Assignment getLatestAssignmentForEmployee(Long empId) {
        return this.assignmentService.getPrimaryAssignmentForEmployee(empId);
    }

    @Deprecated
    public Assignment getLatestAssignmentForEmployeeByToDate(Long empId, Date toDate) {
        return this.assignmentService.getPrimaryAssignmentForEmployeeByToDate(empId, toDate);
    }

    public Assignment getLatestAssignmentForEmployeeByDate(Long empId, Date toDate) {
        return this.assignmentService.findByEmployeeAndGivenDate(empId, toDate).get(0);
    }

    @Deprecated
    public Position getPrimaryAssignmentPositionForEmp(Long empId) {
        return this.assignmentService.getPrimaryAssignmentForEmployee(empId).getPosition();
    }

    @Deprecated
    public Employee getPrimaryAssignmentEmployeeForPos(Long posId) {
        return this.assignmentService.getPrimaryAssignmentForPositon(posId).getEmployee();
    }

    @Deprecated
    public PersonalInformation getEmployeeByUserId(Long userId) {
        return this.personalInformationService.getEmployeeByUserId(userId);
    }

    @Deprecated
    public Boolean isHod(Long assignId) {
        List<HeadOfDepartments> hodList = this.employeeDepartmentRepository.getAllHodDepartments(assignId);
        return !hodList.isEmpty();
    }

    @Deprecated
    public Employee getEmployeeForPositionAndDate(Long posId, Date givenDate) {
        return this.assignmentService.getPrimaryAssignmentForPositionAndDate(posId, givenDate).getEmployee();
    }

    public List<User> getAllActiveUsersByGivenDesig(Long designationId) {
        HashSet<Employee> users = new HashSet<Employee>();
        List<Assignment> assignments = this.assignmentService.getAllActiveAssignments(designationId);
        for (Assignment assign : assignments) {
            users.add(assign.getEmployee());
        }
        return new ArrayList<User>(users);
    }
}

